/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.dali.util;

import ca.nrc.cadc.dali.util.Format;
import java.util.UUID;
import org.apache.log4j.Logger;

public class UUIDFormat
implements Format<UUID> {
    private static final Logger log = Logger.getLogger(UUIDFormat.class);

    @Override
    public UUID parse(String s) {
        if (s == null) {
            return null;
        }
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("invalid UUID: " + s);
        }
    }

    @Override
    public String format(UUID t) {
        if (t == null) {
            return "";
        }
        return t.toString();
    }

    public UUID bytesToUUID(byte[] bytes) {
        int i;
        long hi = 0L;
        long lo = 0L;
        for (i = 0; i < 8; ++i) {
            hi = hi << 8 | (long)(bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lo = lo << 8 | (long)(bytes[i] & 0xFF);
        }
        return new UUID(hi, lo);
    }
}

