/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc;

import ca.nrc.cadc.stc.Box;
import ca.nrc.cadc.stc.CoordPair;
import ca.nrc.cadc.stc.Flavor;
import ca.nrc.cadc.stc.Frame;
import ca.nrc.cadc.stc.ReferencePosition;
import ca.nrc.cadc.stc.Region;
import java.util.ArrayList;
import java.util.List;

public class Polygon
extends Region {
    public static final String NAME = Polygon.class.getSimpleName();
    private List<CoordPair> coordPairs;

    public Polygon(Frame frame, ReferencePosition refpos, Flavor flavor, List<CoordPair> coordPairs) {
        super(NAME, frame, refpos, flavor);
        this.coordPairs = coordPairs;
        if (coordPairs == null || coordPairs.size() < 3) {
            throw new IllegalArgumentException("Polygon requires at least 3 CoordPairs");
        }
    }

    public static Polygon getPolygon(Box box) {
        double x = box.getCoordPair().getX();
        double y = box.getCoordPair().getY();
        double hw = box.getWidth() / 2.0;
        double hh = box.getHeight() / 2.0;
        double hwTop = hw / Math.cos(Math.toRadians(y + hh));
        double hwBottom = hw / Math.cos(Math.toRadians(y - hh));
        ArrayList<CoordPair> corners = new ArrayList<CoordPair>(4);
        CoordPair corner = new CoordPair(x - hwBottom, y - hh);
        corners.add(corner);
        corner = new CoordPair(x - hwTop, y + hh);
        corners.add(corner);
        corner = new CoordPair(x + hwTop, y + hh);
        corners.add(corner);
        corner = new CoordPair(x + hwBottom, y - hh);
        corners.add(corner);
        return new Polygon(null, null, null, corners);
    }

    public List<CoordPair> getCoordPairs() {
        return this.coordPairs;
    }
}

