/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc;

import ca.nrc.cadc.stc.AstroCoordArea;
import ca.nrc.cadc.stc.Box;
import ca.nrc.cadc.stc.Circle;
import ca.nrc.cadc.stc.Intersection;
import ca.nrc.cadc.stc.Not;
import ca.nrc.cadc.stc.Polygon;
import ca.nrc.cadc.stc.Position;
import ca.nrc.cadc.stc.Region;
import ca.nrc.cadc.stc.Regions;
import ca.nrc.cadc.stc.SpectralInterval;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.Union;
import ca.nrc.cadc.stc.util.BoxFormat;
import ca.nrc.cadc.stc.util.CircleFormat;
import ca.nrc.cadc.stc.util.IntersectionFormat;
import ca.nrc.cadc.stc.util.NotFormat;
import ca.nrc.cadc.stc.util.PolygonFormat;
import ca.nrc.cadc.stc.util.PositionFormat;
import ca.nrc.cadc.stc.util.SpectralIntervalFormat;
import ca.nrc.cadc.stc.util.UnionFormat;

public class STC {
    public static Region parseRegion(String phrase) throws StcsParsingException {
        if (phrase == null || phrase.trim().isEmpty()) {
            return null;
        }
        int index = (phrase = phrase.trim()).indexOf(" ");
        String region = index == -1 ? phrase : phrase.substring(0, index);
        if (region.equalsIgnoreCase(Box.NAME)) {
            BoxFormat format = new BoxFormat();
            return format.parse(phrase);
        }
        if (region.equalsIgnoreCase(Circle.NAME)) {
            CircleFormat format = new CircleFormat();
            return format.parse(phrase);
        }
        if (region.equalsIgnoreCase(Not.NAME)) {
            NotFormat format = new NotFormat();
            return format.parse(phrase);
        }
        if (region.equalsIgnoreCase(Polygon.NAME)) {
            PolygonFormat format = new PolygonFormat();
            return format.parse(phrase);
        }
        if (region.equalsIgnoreCase(Position.NAME)) {
            PositionFormat format = new PositionFormat();
            return format.parse(phrase);
        }
        if (region.equalsIgnoreCase(Union.NAME)) {
            UnionFormat format = new UnionFormat();
            return format.parse(phrase);
        }
        if (region.equalsIgnoreCase(Intersection.NAME)) {
            IntersectionFormat format = new IntersectionFormat();
            return format.parse(phrase);
        }
        throw new UnsupportedOperationException("Unsupported phrase " + phrase);
    }

    public static SpectralInterval parseSpectralInterval(String phrase) throws StcsParsingException {
        if (phrase == null || phrase.trim().isEmpty()) {
            return null;
        }
        phrase = phrase.trim();
        SpectralIntervalFormat format = new SpectralIntervalFormat();
        return format.parse(phrase);
    }

    public static AstroCoordArea parseAstroCoordArea(String phrase) throws StcsParsingException {
        if (phrase == null || phrase.trim().isEmpty()) {
            return null;
        }
        phrase = phrase.trim();
        int index = 0;
        String[] words = phrase.split("\\s+");
        String currentWord = words[index];
        Region region = null;
        if (Regions.contains(currentWord.toUpperCase())) {
            StringBuilder sb = new StringBuilder();
            sb.append(currentWord);
            sb.append(" ");
            for (index = 1; index < words.length && !(currentWord = words[index]).equalsIgnoreCase(SpectralInterval.NAME); ++index) {
                sb.append(currentWord);
                sb.append(" ");
                currentWord = null;
            }
            region = STC.parseRegion(sb.toString().trim());
        }
        SpectralInterval spectralInterval = null;
        if (currentWord != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = index; i < words.length; ++i) {
                sb.append(words[i]);
                sb.append(" ");
            }
            spectralInterval = STC.parseSpectralInterval(sb.toString().trim());
        }
        return new AstroCoordArea(region, spectralInterval);
    }

    @Deprecated
    public static Region parse(String phrase) throws StcsParsingException {
        return STC.parseRegion(phrase);
    }

    public static String format(Region region) {
        if (region == null) {
            return "";
        }
        if (region instanceof Box) {
            BoxFormat format = new BoxFormat();
            return format.format((Box)region);
        }
        if (region instanceof Circle) {
            CircleFormat format = new CircleFormat();
            return format.format((Circle)region);
        }
        if (region instanceof Not) {
            NotFormat format = new NotFormat();
            return format.format((Not)region);
        }
        if (region instanceof Polygon) {
            PolygonFormat format = new PolygonFormat();
            return format.format((Polygon)region);
        }
        if (region instanceof Position) {
            PositionFormat format = new PositionFormat();
            return format.format((Position)region);
        }
        if (region instanceof Union) {
            UnionFormat format = new UnionFormat();
            return format.format((Union)region);
        }
        if (region instanceof Intersection) {
            IntersectionFormat format = new IntersectionFormat();
            return format.format((Intersection)region);
        }
        throw new UnsupportedOperationException("Unsupported Region " + region.getClass().getName());
    }

    public static String format(SpectralInterval spectralInterval) {
        if (spectralInterval == null) {
            return "";
        }
        SpectralIntervalFormat format = new SpectralIntervalFormat();
        return format.format(spectralInterval);
    }

    public static String format(AstroCoordArea astroCoordArea) {
        if (astroCoordArea == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (astroCoordArea.getRegion() != null) {
            sb.append(STC.format(astroCoordArea.getRegion()));
        }
        if (astroCoordArea.getRegion() != null && astroCoordArea.getSpectralInterval() != null) {
            sb.append(" ");
        }
        if (astroCoordArea.getSpectralInterval() != null) {
            sb.append(STC.format(astroCoordArea.getSpectralInterval()));
        }
        return sb.toString();
    }
}

