/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Box;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;

public class BoxFormat
extends RegionFormat
implements Format<Box> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Box parse(String phrase) throws StcsParsingException {
        this.parseRegion(phrase);
        Double x = null;
        if (this.currentWord == null) {
            if (!this.words.hasNextDouble()) {
                if (!this.words.hasNext()) throw new StcsParsingException("Unexpected end to STC-S phrase before CoordPair element");
                throw new StcsParsingException("Invalid CoordPair element " + this.words.next());
            }
            x = this.words.nextDouble();
        } else {
            try {
                x = Double.valueOf(this.currentWord);
            }
            catch (NumberFormatException e) {
                throw new StcsParsingException("Invalid CoordPair " + this.currentWord + " in " + phrase);
            }
        }
        if (!this.words.hasNextDouble()) throw new StcsParsingException("Coordpair not found in " + phrase);
        Double y = this.words.nextDouble();
        if (!this.words.hasNextDouble()) throw new StcsParsingException("Width not found in " + phrase);
        double width = this.words.nextDouble();
        if (!this.words.hasNextDouble()) throw new StcsParsingException("Height not found in " + phrase);
        double height = this.words.nextDouble();
        return new Box(this.frame, this.refpos, this.flavor, x, y, width, height);
    }

    @Override
    public String format(Box box) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(box));
        sb.append(" ");
        if (box.getCoordPair() != null) {
            sb.append(box.getCoordPair());
            sb.append(" ");
        }
        sb.append(box.getWidth());
        sb.append(" ");
        sb.append(box.getHeight());
        return sb.toString().trim();
    }
}

