/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Intersection;
import ca.nrc.cadc.stc.Region;
import ca.nrc.cadc.stc.Regions;
import ca.nrc.cadc.stc.STC;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class IntersectionFormat
extends RegionFormat
implements Format<Intersection> {
    @Override
    public Intersection parse(String phrase) throws StcsParsingException {
        this.parseRegion(phrase);
        int open = phrase.indexOf("(");
        int close = phrase.lastIndexOf(")");
        if (open == -1 || close == -1) {
            throw new StcsParsingException("Intersection arguments must be enclosed in parentheses: " + phrase);
        }
        String union = phrase.substring(open + 1, close).trim();
        int index = 0;
        ArrayList<Region> regions = null;
        String subPhrase = this.getNextRegion(union, index);
        if (subPhrase == null) {
            throw new StcsParsingException("Intersection must contain a Region: " + phrase);
        }
        while (subPhrase != null) {
            if (regions == null) {
                regions = new ArrayList<Region>();
            }
            regions.add(STC.parseRegion(subPhrase));
            subPhrase = this.getNextRegion(union, index += subPhrase.length());
        }
        if (regions == null || regions.size() < 2) {
            throw new StcsParsingException("Intersection must contain 2 or more Regions: " + phrase);
        }
        return new Intersection(this.frame, this.refpos, this.flavor, regions);
    }

    @Override
    public String format(Intersection intersection) {
        if (!(intersection instanceof Intersection)) {
            throw new IllegalArgumentException("Expected Intersection, was " + intersection.getClass().getName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(intersection));
        sb.append(" ( ");
        for (Region r : intersection.getRegions()) {
            sb.append(STC.format(r));
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString().trim();
    }

    private String getNextRegion(String phrase, int index) {
        String upperPhrase = phrase.toUpperCase();
        Regions[] values = Regions.values();
        int[] indexes = new int[values.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = upperPhrase.indexOf(values[i].name(), index);
        }
        Arrays.sort(indexes);
        int start = -1;
        int end = -1;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == -1) continue;
            if (start == -1) {
                start = indexes[i];
                continue;
            }
            if (end != -1) continue;
            end = indexes[i];
            break;
        }
        if (start != -1 && end == -1) {
            return phrase.substring(start);
        }
        if (start != -1 && end != -1) {
            return phrase.substring(start, end);
        }
        return null;
    }
}

