/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.CoordPair;
import ca.nrc.cadc.stc.Polygon;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;
import java.util.ArrayList;

public class PolygonFormat
extends RegionFormat
implements Format<Polygon> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Polygon parse(String phrase) throws StcsParsingException {
        Double value;
        block10: {
            this.parseRegion(phrase);
            value = null;
            if (this.currentWord == null) {
                if (this.words.hasNextDouble()) {
                    value = this.words.nextDouble();
                    break block10;
                } else {
                    if (this.words.hasNext()) {
                        throw new StcsParsingException("Invalid CoordPair " + this.words.next());
                    }
                    throw new StcsParsingException("Unexpected end to STC-S phrase before CoordPair");
                }
            }
            try {
                value = Double.valueOf(this.currentWord);
            }
            catch (NumberFormatException e) {
                throw new StcsParsingException("Invalid CoordPair " + this.currentWord + " in " + phrase);
            }
        }
        ArrayList<CoordPair> coordPairs = new ArrayList<CoordPair>();
        if (!this.words.hasNextDouble()) {
            throw new StcsParsingException("Polygon must contain at least 3 CoordPairs: " + phrase);
        }
        coordPairs.add(new CoordPair(value, this.words.nextDouble()));
        while (this.words.hasNextDouble()) {
            value = this.words.nextDouble();
            if (!this.words.hasNextDouble()) {
                throw new StcsParsingException("Polygon must contain at least 3 CoordPairs: " + phrase);
            }
            coordPairs.add(new CoordPair(value, this.words.nextDouble()));
        }
        if (coordPairs.size() < 3) {
            throw new StcsParsingException("Polygon must contain at least 3 CoordPairs: " + phrase);
        }
        return new Polygon(this.frame, this.refpos, this.flavor, coordPairs);
    }

    @Override
    public String format(Polygon polygon) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(polygon));
        sb.append(" ");
        if (polygon.getCoordPairs() != null) {
            for (CoordPair coordPair : polygon.getCoordPairs()) {
                sb.append(coordPair);
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }
}

