/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Position;
import ca.nrc.cadc.stc.StcsParsingException;
import ca.nrc.cadc.stc.util.Format;
import ca.nrc.cadc.stc.util.RegionFormat;

public class PositionFormat
extends RegionFormat
implements Format<Position> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Position parse(String phrase) throws StcsParsingException {
        double x;
        this.parseRegion(phrase);
        if (this.currentWord == null) {
            if (!this.words.hasNextDouble()) {
                if (!this.words.hasNext()) throw new StcsParsingException("Unexpected end to STC-S phrase before coordpair element");
                throw new StcsParsingException("Invalid coordpair element " + this.words.next());
            }
            x = this.words.nextDouble();
        } else {
            try {
                x = Double.valueOf(this.currentWord);
            }
            catch (NumberFormatException e) {
                throw new StcsParsingException("Invalid coordpair " + this.currentWord + " in " + phrase);
            }
        }
        if (!this.words.hasNextDouble()) throw new StcsParsingException("Coordpair not found in " + phrase);
        double y = this.words.nextDouble();
        return new Position(this.frame, this.refpos, this.flavor, x, y);
    }

    @Override
    public String format(Position position) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatRegion(position));
        sb.append(" ");
        sb.append(position.getCoordPair());
        return sb.toString().trim();
    }
}

