/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.stc.util;

import ca.nrc.cadc.stc.Flavor;
import ca.nrc.cadc.stc.Frame;
import ca.nrc.cadc.stc.ReferencePosition;
import ca.nrc.cadc.stc.Region;
import ca.nrc.cadc.stc.Regions;
import ca.nrc.cadc.stc.StcsParsingException;
import java.util.Scanner;

public abstract class RegionFormat {
    public static final Frame DEFAULT_FRAME = Frame.UNKNOWNFRAME;
    public static final ReferencePosition DEFAULT_REFPOS = ReferencePosition.UNKNOWNREFPOS;
    public static final Flavor DEFAULT_FLAVOR = Flavor.SPHERICAL2;
    protected String name;
    protected Frame frame;
    protected ReferencePosition refpos;
    protected Flavor flavor;
    protected Scanner words;
    protected String currentWord;

    protected void parseRegion(String phrase) throws StcsParsingException {
        if (phrase == null || phrase.isEmpty()) {
            return;
        }
        phrase = phrase.trim();
        this.frame = null;
        this.refpos = null;
        this.flavor = null;
        this.currentWord = null;
        this.words = new Scanner(phrase);
        this.words.useDelimiter("\\s+");
        this.currentWord = this.getNextWord(this.words, this.currentWord);
        if (!Regions.contains(this.currentWord.toUpperCase())) {
            throw new StcsParsingException("Invalid region " + this.currentWord);
        }
        this.name = this.currentWord;
        this.currentWord = null;
        this.currentWord = this.getNextWord(this.words, this.currentWord);
        if (Frame.contains(this.currentWord.toUpperCase())) {
            this.frame = Frame.valueOf(this.currentWord.toUpperCase());
            this.currentWord = null;
        }
        this.currentWord = this.getNextWord(this.words, this.currentWord);
        if (ReferencePosition.contains(this.currentWord.toUpperCase())) {
            this.refpos = ReferencePosition.valueOf(this.currentWord.toUpperCase());
            this.currentWord = null;
        }
        this.currentWord = this.getNextWord(this.words, this.currentWord);
        if (Flavor.contains(this.currentWord.toUpperCase())) {
            this.flavor = Flavor.valueOf(this.currentWord.toUpperCase());
            this.currentWord = null;
        }
    }

    protected String formatRegion(Region region) {
        StringBuilder sb = new StringBuilder();
        sb.append(region.getName());
        sb.append(" ");
        if (region.getFrame() != null) {
            sb.append(region.getFrame().name());
            sb.append(" ");
        }
        if (region.getRefPos() != null) {
            sb.append(region.getRefPos().name());
            sb.append(" ");
        }
        if (region.getFlavor() != null) {
            sb.append(region.getFlavor().name());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    protected String getNextWord(Scanner words, String currentWord) throws StcsParsingException {
        if (currentWord == null) {
            if (words.hasNext()) {
                return words.next();
            }
            throw new StcsParsingException("Unexpected end to STC-S phrase " + words.toString());
        }
        return currentWord;
    }

    public String getName() {
        return this.name;
    }

    public Frame getFrame() {
        if (this.frame == null) {
            return DEFAULT_FRAME;
        }
        return this.frame;
    }

    public ReferencePosition getReferencePosition() {
        if (this.refpos == null) {
            return DEFAULT_REFPOS;
        }
        return this.refpos;
    }

    public Flavor getFlavor() {
        if (this.flavor == null) {
            return DEFAULT_FLAVOR;
        }
        return this.flavor;
    }
}

