/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FlagIO;

public class BinaryRowSequence
implements RowSequence {
    private final PushbackInputStream pIn_;
    private final DataInput dataIn_;
    private final int ncol_;
    private final RowReader rowReader_;
    private Object[] row_;

    public BinaryRowSequence(final Decoder[] decoders, InputStream in, String encoding, boolean isBinary2) throws IOException {
        this.ncol_ = decoders.length;
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        } else if ("base64".equals(encoding)) {
            in = new Base64InputStream(in);
        }
        this.pIn_ = new PushbackInputStream(in);
        this.dataIn_ = new DataInputStream(this.pIn_);
        this.rowReader_ = isBinary2 ? new RowReader(){
            final boolean[] nullFlags;
            {
                this.nullFlags = new boolean[BinaryRowSequence.this.ncol_];
            }

            @Override
            public void readRow(Object[] row) throws IOException {
                FlagIO.readFlags(BinaryRowSequence.this.dataIn_, this.nullFlags);
                for (int icol = 0; icol < BinaryRowSequence.this.ncol_; ++icol) {
                    Object cell;
                    Decoder decoder = decoders[icol];
                    if (this.nullFlags[icol]) {
                        decoder.skipStream(BinaryRowSequence.this.dataIn_);
                        cell = null;
                    } else {
                        cell = decoder.decodeStream(BinaryRowSequence.this.dataIn_);
                    }
                    row[icol] = cell;
                }
            }
        } : new RowReader(){

            @Override
            public void readRow(Object[] row) throws IOException {
                for (int icol = 0; icol < BinaryRowSequence.this.ncol_; ++icol) {
                    row[icol] = decoders[icol].decodeStream(BinaryRowSequence.this.dataIn_);
                }
            }
        };
    }

    @Override
    public boolean next() throws IOException {
        int b;
        try {
            b = this.pIn_.read();
        }
        catch (EOFException e) {
            return false;
        }
        if (b < 0) {
            return false;
        }
        this.pIn_.unread(b);
        Object[] row = new Object[this.ncol_];
        this.rowReader_.readRow(row);
        this.row_ = row;
        return true;
    }

    @Override
    public Object[] getRow() {
        if (this.row_ != null) {
            return this.row_;
        }
        throw new IllegalStateException("No next() yet");
    }

    @Override
    public Object getCell(int icol) {
        if (this.row_ != null) {
            return this.row_[icol];
        }
        throw new IllegalStateException("No next() yet");
    }

    @Override
    public void close() throws IOException {
        this.pIn_.close();
    }

    private static interface RowReader {
        public void readRow(Object[] var1) throws IOException;
    }
}

