/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class FlagIO {
    FlagIO() {
    }

    public static void writeFlags(DataOutput out, boolean[] flags) throws IOException {
        int nflag = flags.length;
        int buf = 0;
        for (int iflag = 0; iflag < nflag; ++iflag) {
            int ibit = iflag % 8;
            if (ibit == 0 && iflag > 0) {
                out.write(buf);
                buf = 0;
            }
            if (!flags[iflag]) continue;
            buf |= FlagIO.mask(ibit);
        }
        out.write(buf);
    }

    public static void readFlags(DataInput in, boolean[] flags) throws IOException {
        int nflag = flags.length;
        int buf = 0;
        for (int iflag = 0; iflag < nflag; ++iflag) {
            int ibit = iflag % 8;
            if (ibit == 0) {
                buf = in.readUnsignedByte();
            }
            flags[iflag] = (buf & FlagIO.mask(ibit)) != 0;
        }
    }

    private static int mask(int ibit) {
        return 128 >> ibit;
    }
}

