/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Capability {
    private static final Logger log = Logger.getLogger(Capability.class);
    private final URI standardID;
    private final List<Interface> interfaces = new ArrayList<Interface>();
    private Namespace extensionNamespace;
    private Attribute extensionType;
    private List<Element> extensionMetadata = new ArrayList<Element>();

    public Capability(URI standardID) {
        this.validateParams(standardID);
        this.standardID = standardID;
    }

    public URI getStandardID() {
        return this.standardID;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public Interface findInterface(URI securityMethod) {
        return this.findInterface(securityMethod, Standards.INTERFACE_PARAM_HTTP);
    }

    public Interface findInterface(URI securityMethod, URI interfaceType) {
        boolean anon = securityMethod == null || Standards.SECURITY_METHOD_ANON.equals(securityMethod);
        for (Interface intf : this.interfaces) {
            if (anon && intf.getSecurityMethods().isEmpty() && intf.getType().equals(interfaceType)) {
                return intf;
            }
            for (URI sm : intf.getSecurityMethods()) {
                if (!intf.getType().equals(interfaceType) || securityMethod != null && !sm.equals(securityMethod)) continue;
                return intf;
            }
        }
        return null;
    }

    public Interface findInterface(AuthMethod authMethod) {
        return this.findInterface(authMethod, Standards.INTERFACE_PARAM_HTTP);
    }

    public Interface findInterface(AuthMethod authMethod, URI interfaceType) {
        URI secMethod = Standards.getSecurityMethod(authMethod);
        return this.findInterface(secMethod, interfaceType);
    }

    void setExtensionNamespace(Namespace extensionNamespace) {
        this.extensionNamespace = extensionNamespace;
    }

    void setExtensionType(Attribute extensionType) {
        this.extensionType = extensionType;
    }

    Namespace getExtensionNamespace() {
        return this.extensionNamespace;
    }

    Attribute getExtensionType() {
        return this.extensionType;
    }

    List<Element> getExtensionMetadata() {
        return this.extensionMetadata;
    }

    private void validateParams(URI standardID) {
        if (standardID == null) {
            String msg = "standard identifier for a Capability object cannot be null.";
            throw new IllegalArgumentException(msg);
        }
    }
}

