/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg.client;

import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.profiler.Profiler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.log4j.Logger;

public class CachingFile {
    private static Logger log = Logger.getLogger(CachingFile.class);
    private static final int DEFAULT_EXPRIY_SECONDS = 600;
    private int connectionTimeout = 3000;
    private int readTimeout = 60000;
    private File localCache;
    private URL remoteSource;
    private long expirySeconds;
    private File cacheDir;

    public CachingFile(File localCache, URL remoteSource) {
        this(localCache, remoteSource, 600L);
    }

    public CachingFile(File localCache, URL remoteSource, long expirySeconds) {
        if (localCache == null) {
            throw new IllegalArgumentException("localCache param required.");
        }
        this.cacheDir = this.checkCacheDirectory(localCache);
        if (remoteSource == null) {
            throw new IllegalArgumentException("remoteSource param required.");
        }
        if (remoteSource.getProtocol() == null || !remoteSource.getProtocol().toLowerCase().equals("http") && !remoteSource.getProtocol().toLowerCase().equals("https")) {
            throw new IllegalArgumentException("only http/https schemes allowed in remoteSource");
        }
        this.localCache = localCache;
        this.remoteSource = remoteSource;
        this.expirySeconds = expirySeconds;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private File checkCacheDirectory(File cacheFile) {
        Profiler profiler = new Profiler(CachingFile.class);
        log.debug((Object)("Cache file: " + cacheFile));
        try {
            File dir = cacheFile.getParentFile();
            log.debug((Object)("cache file parent dir: " + dir));
            if (dir.exists() && !dir.isDirectory()) {
                Files.delete(dir.toPath());
            }
            if (!dir.exists()) {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                log.debug((Object)("Created directory " + dir));
            }
            File file = dir;
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create directory: " + cacheFile.getParentFile(), e);
        }
        finally {
            profiler.checkpoint("checkCacheDirectory");
        }
    }

    public String getContent() throws IOException {
        boolean cacheExists;
        boolean bl = cacheExists = this.localCache.exists() && this.localCache.canRead();
        if (cacheExists && !this.hasExpired()) {
            log.debug((Object)("Reading cache for file " + this.localCache));
            try {
                return this.readCache();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to read cached file: " + this.localCache));
                log.warn((Object)"Attempting to read capabilities from source.");
            }
        }
        try {
            File tmpFile = File.createTempFile(UUID.randomUUID().toString(), null, this.cacheDir);
            FileOutputStream fos = new FileOutputStream(tmpFile);
            try {
                this.loadRemoteContent(fos);
            }
            catch (IOException e) {
                log.warn((Object)"Deleting tmp cache file because download failed.");
                tmpFile.delete();
                throw e;
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to close output stream", (Throwable)e);
                }
            }
            Path source = Paths.get(tmpFile.getAbsolutePath(), new String[0]);
            Path dest = Paths.get(this.localCache.getAbsolutePath(), new String[0]);
            try {
                Files.move(source, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                log.debug((Object)("Replaced file " + this.localCache + " with fresh copy atomically."));
            }
            catch (AtomicMoveNotSupportedException e) {
                log.warn((Object)"Atomic file replacement not supported", (Throwable)e);
                Files.move(source, dest, StandardCopyOption.REPLACE_EXISTING);
                log.debug((Object)("Replaced file " + this.localCache + " with fresh copy (not atomically)."));
            }
            return this.readCache();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to cache capabilities to file: " + this.localCache), (Throwable)e);
            if (cacheExists) {
                log.warn((Object)"Returning expired cached capabilities.");
                return this.readCache();
            }
            log.info((Object)"Attemping to return capabilities from source.");
            return this.getRemoteContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCache() throws IOException {
        Profiler profiler = new Profiler(CachingFile.class);
        log.debug((Object)("Reading cache from " + this.localCache.getAbsolutePath()));
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            int length;
            in = new FileInputStream(this.localCache);
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            String string = out.toString("UTF-8");
            return string;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable t) {
                    log.warn((Object)"failed to close input stream", t);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable t) {
                    log.warn((Object)"failed to close output stream", t);
                }
            }
            profiler.checkpoint("readCache");
        }
    }

    private String getRemoteContent() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.loadRemoteContent(out);
        return out.toString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRemoteContent(OutputStream dest) throws IOException {
        Profiler profiler = new Profiler(CachingFile.class);
        try {
            HttpGet download = new HttpGet(this.remoteSource, dest);
            download.setConnectionTimeout(this.connectionTimeout);
            download.setReadTimeout(this.readTimeout);
            download.run();
            if (download.getThrowable() != null) {
                log.warn((Object)("Could not get source from " + this.remoteSource + ": " + download.getThrowable()));
                throw new IOException(download.getThrowable());
            }
        }
        finally {
            profiler.checkpoint("loadRemoteContent");
        }
    }

    private boolean hasExpired() {
        long lastModified = this.localCache.lastModified();
        long expiryMillis = this.expirySeconds * 1000L;
        long now = System.currentTimeMillis();
        return now - lastModified > expiryMillis;
    }
}

