/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg.client;

import ca.nrc.cadc.util.InvalidConfigException;
import ca.nrc.cadc.util.MultiValuedProperties;
import ca.nrc.cadc.util.PropertiesReader;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class LocalAuthority {
    private static final Logger log = Logger.getLogger(LocalAuthority.class);
    private static final Set<URI> EMPTY_SET = Collections.unmodifiableSet(Collections.EMPTY_SET);
    private final Map<URI, Set<URI>> authorityMap = new TreeMap<URI, Set<URI>>();

    public LocalAuthority() {
        PropertiesReader propReader = new PropertiesReader("cadc-registry.properties");
        MultiValuedProperties mvp = propReader.getAllProperties();
        for (String std : mvp.keySet()) {
            List values = mvp.getProperty(std);
            TreeSet<URI> vals = new TreeSet<URI>();
            URI stdURI = URI.create(std);
            this.authorityMap.put(stdURI, vals);
            for (String val : values) {
                URI valURI = URI.create(val);
                log.debug((Object)("authorityMap: " + stdURI + " -> " + valURI));
                vals.add(valURI);
            }
        }
    }

    @Deprecated
    public URI getServiceURI(String baseStandardID) {
        Set<URI> resourceIdentifiers = this.lookup(URI.create(baseStandardID));
        if (resourceIdentifiers.isEmpty()) {
            throw new NoSuchElementException("not found: " + baseStandardID);
        }
        if (resourceIdentifiers.size() > 1) {
            throw new NoSuchElementException("Multiple service URIs found for " + baseStandardID);
        }
        return resourceIdentifiers.iterator().next();
    }

    public URI getResourceID(URI standardID) {
        return this.getResourceID(standardID, true);
    }

    public URI getResourceID(URI standardID, boolean failOnMultiple) {
        Set<URI> s = this.lookup(standardID);
        if (s.isEmpty()) {
            return null;
        }
        if (failOnMultiple && s.size() > 1) {
            throw new InvalidConfigException("found multiple values for " + standardID);
        }
        return s.iterator().next();
    }

    public Set<URI> getResourceIDs(URI standardID) {
        return this.lookup(standardID);
    }

    private Set<URI> lookup(URI standardID) {
        Set<URI> ret = this.authorityMap.get(standardID);
        if (ret == null) {
            return EMPTY_SET;
        }
        return ret;
    }
}

