/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.reg.client;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.CapabilitiesReader;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.CachingFile;
import ca.nrc.cadc.util.InvalidConfigException;
import ca.nrc.cadc.util.MultiValuedProperties;
import ca.nrc.cadc.util.PropertiesReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.log4j.Logger;

public class RegistryClient {
    private static Logger log = Logger.getLogger(RegistryClient.class);
    private static final String HOST_PROPERTY = RegistryClient.class.getName() + ".host";
    private static final String CONFIG_BASE_URL = RegistryClient.class.getName() + ".baseURL";
    static final String CONFIG_FILE = "cadc-registry.properties";
    static final String CONFIG_CACHE_DIR = "cadc-registry-1.5";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final URI DEFAULT_ITYPE = Standards.INTERFACE_PARAM_HTTP;
    private URL regBaseURL;
    private String capsDomain;
    private boolean isRegOverride = false;
    private int connectionTimeout = 30000;
    private int readTimeout = 60000;

    public RegistryClient() {
        PropertiesReader propReader = new PropertiesReader(CONFIG_FILE);
        MultiValuedProperties mvp = propReader.getAllProperties();
        String str = mvp.getFirstPropertyValue(CONFIG_BASE_URL);
        if (str != null) {
            try {
                if (str.endsWith("/")) {
                    str = str.substring(0, str.length() - 1);
                }
                this.regBaseURL = new URL(str);
            }
            catch (MalformedURLException ex) {
                throw new InvalidConfigException("cadc-registry.properties: " + CONFIG_BASE_URL + " = " + str + " is not a valid URL", (Throwable)ex);
            }
        }
        try {
            String hostP = System.getProperty(HOST_PROPERTY);
            log.debug((Object)("     host: " + hostP));
            if (hostP != null) {
                this.regBaseURL = new URL("https://" + hostP + "/reg");
                this.isRegOverride = true;
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"Error transforming resource-caps URL", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.regBaseURL != null) {
            this.capsDomain = "reg-domains/" + this.regBaseURL.getHost();
        }
        log.debug((Object)("regBaseURL: " + this.regBaseURL + " domain: " + this.capsDomain));
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isRegistryLookupOverride() {
        return this.isRegOverride;
    }

    public URL getAccessURL(URI resourceID) throws IOException, ResourceNotFoundException {
        return this.getAccessURL(Query.CAPABILITIES, resourceID);
    }

    public URL getAccessURL(Query queryName, URI uri) throws IOException, ResourceNotFoundException {
        if (this.regBaseURL == null) {
            throw new IllegalStateException("no registry service base URL configured");
        }
        File queryCacheFile = this.getQueryCacheFile(queryName);
        log.debug((Object)("resource-caps cache file: " + queryCacheFile));
        URL queryURL = new URL(this.regBaseURL + "/" + queryName.getValue());
        CachingFile cachedCapSource = new CachingFile(queryCacheFile, queryURL);
        cachedCapSource.setConnectionTimeout(this.connectionTimeout);
        cachedCapSource.setReadTimeout(this.readTimeout);
        String map = cachedCapSource.getContent();
        ByteArrayInputStream mapStream = new ByteArrayInputStream(map.getBytes(StandardCharsets.UTF_8));
        MultiValuedProperties mvp = new MultiValuedProperties();
        try {
            mvp.load((InputStream)mapStream);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load properties from cache, src=" + queryURL, e);
        }
        List values = mvp.getProperty(uri.toString());
        if (values == null || values.isEmpty()) {
            throw new ResourceNotFoundException("not found: " + uri + " src=" + queryURL);
        }
        if (values.size() > 1) {
            throw new RuntimeException("multiple values for " + uri + " src=" + queryURL);
        }
        try {
            return new URL((String)values.get(0));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed URL for " + uri + " src=" + queryURL, e);
        }
    }

    public Capabilities getCapabilities(URI resourceID) throws IOException, ResourceNotFoundException {
        if (resourceID == null) {
            String msg = "Input parameter (resourceID) should not be null";
            throw new IllegalArgumentException(msg);
        }
        URL serviceCapsURL = this.getAccessURL(Query.CAPABILITIES, resourceID);
        log.debug((Object)("Service capabilities URL: " + serviceCapsURL));
        File capabilitiesFile = this.getCapabilitiesCacheFile(resourceID);
        CachingFile cachedCapabilities = new CachingFile(capabilitiesFile, serviceCapsURL);
        cachedCapabilities.setConnectionTimeout(this.connectionTimeout);
        cachedCapabilities.setReadTimeout(this.readTimeout);
        String xml = cachedCapabilities.getContent();
        CapabilitiesReader capReader = new CapabilitiesReader();
        return capReader.read(xml);
    }

    public URL getServiceURL(URI resourceIdentifier, URI standardID, AuthMethod authMethod) {
        return this.getServiceURL(resourceIdentifier, standardID, authMethod, DEFAULT_ITYPE);
    }

    public URL getServiceURL(URI resourceID, URI standardID, AuthMethod authMethod, URI interfaceType) {
        Interface intf;
        if (resourceID == null || standardID == null || interfaceType == null) {
            String msg = "No input parameters should be null";
            throw new IllegalArgumentException(msg);
        }
        URL url = null;
        log.debug((Object)("resourceIdentifier=" + resourceID + ", standardID=" + standardID + ", authMethod=" + authMethod + ", interfaceType=" + interfaceType));
        Capabilities caps = null;
        try {
            caps = this.getCapabilities(resourceID);
        }
        catch (ResourceNotFoundException ex) {
            log.warn((Object)("getCapabilities: " + ex));
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not obtain service URL", e);
        }
        Capability cap = caps.findCapability(standardID);
        if (cap != null && (intf = cap.findInterface(authMethod, interfaceType)) != null) {
            url = intf.getAccessURL().getURL();
        }
        return url;
    }

    File getQueryCacheFile(Query queryName) {
        Object baseCacheDir = this.getBaseCacheDirectory();
        baseCacheDir = (String)baseCacheDir + FILE_SEP + this.capsDomain;
        String path = FILE_SEP + queryName.getValue();
        log.debug((Object)("getQueryCacheFile [" + path + "] in dir [" + (String)baseCacheDir + "]"));
        File file = new File((String)baseCacheDir + path);
        return file;
    }

    private File getCapabilitiesCacheFile(URI resourceID) {
        String baseCacheDir = this.getBaseCacheDirectory();
        String resourceCacheDir = baseCacheDir + resourceID.getAuthority();
        resourceCacheDir = baseCacheDir + FILE_SEP + this.capsDomain + FILE_SEP + resourceID.getAuthority();
        String path = resourceID.getPath() + FILE_SEP + "capabilities.xml";
        log.debug((Object)("getCapabilitiesCacheFile [" + path + "] in dir [" + resourceCacheDir + "]"));
        File file = new File(resourceCacheDir, path);
        return file;
    }

    private String getBaseCacheDirectory() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String userName = System.getProperty("user.name");
        if (tmpDir == null) {
            throw new RuntimeException("No tmp system dir defined.");
        }
        String baseCacheDir = null;
        baseCacheDir = userName == null ? tmpDir + FILE_SEP + CONFIG_CACHE_DIR : tmpDir + FILE_SEP + userName + FILE_SEP + CONFIG_CACHE_DIR;
        log.debug((Object)("Base cache dir: " + baseCacheDir));
        return baseCacheDir;
    }

    URL getRegistryBaseURL() {
        return this.regBaseURL;
    }

    String getCapsDomain() {
        return this.capsDomain;
    }

    public static enum Query {
        APPLICATIONS("applications"),
        CAPABILITIES("resource-caps");

        private String value;

        private Query(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

