/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.DerParser;
import java.io.IOException;
import java.math.BigInteger;

class Asn1Object {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int PRIVATE = 192;
    public static final int CONSTRUCTED = 32;
    public static final int ANY = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int RELATIVE_OID = 13;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int NUMERIC_STRING = 18;
    public static final int PRINTABLE_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int VIDEOTEX_STRING = 21;
    public static final int IA5_STRING = 22;
    public static final int GRAPHIC_STRING = 25;
    public static final int ISO646_STRING = 26;
    public static final int GENERAL_STRING = 27;
    public static final int UTF8_STRING = 12;
    public static final int UNIVERSAL_STRING = 28;
    public static final int BMP_STRING = 30;
    public static final int UTC_TIME = 23;
    public static final int GENERALIZED_TIME = 24;
    protected final int type;
    protected final int length;
    protected final byte[] value;
    protected final int tag;

    public Asn1Object(int tag, int length, byte[] value) {
        this.tag = tag;
        this.type = tag & 0x1F;
        this.length = length;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public DerParser getParser() throws IOException {
        if (!this.isConstructed()) {
            throw new IOException("Invalid DER: can't parse primitive entity");
        }
        return new DerParser(this.value);
    }

    public BigInteger getInteger() throws IOException {
        if (this.type != 2) {
            throw new IOException("Invalid DER: object is not integer");
        }
        return new BigInteger(this.value);
    }

    public String getString() throws IOException {
        String encoding;
        switch (this.type) {
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                encoding = "ISO-8859-1";
                break;
            }
            case 30: {
                encoding = "UTF-16BE";
                break;
            }
            case 12: {
                encoding = "UTF-8";
                break;
            }
            case 28: {
                throw new IOException("Invalid DER: can't handle UCS-4 string");
            }
            default: {
                throw new IOException("Invalid DER: object is not a string");
            }
        }
        return new String(this.value, encoding);
    }
}

