/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;

public class BasicX509KeyManager
implements X509KeyManager {
    private static Logger log = Logger.getLogger(BasicX509KeyManager.class);
    private X509KeyManager keyManager;
    private String alias;

    public BasicX509KeyManager(X509KeyManager km, String alias) {
        log.debug((Object)"BasicX509KeyManager");
        this.keyManager = km;
        this.alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
        String ret = this.keyManager.chooseClientAlias(strings, prncpls, socket);
        log.debug((Object)("chooseClientAlias: looking for alias by delegating... found " + ret));
        if (ret == null) {
            ret = this.alias;
        }
        log.debug((Object)("chooseClientAlias: " + ret));
        return ret;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
        String ret = this.keyManager.chooseServerAlias(string, prncpls, socket);
        log.debug((Object)("chooseServerAlias: " + ret));
        return ret;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        log.debug((Object)("getCertificateChain: " + alias));
        X509Certificate[] ret = this.keyManager.getCertificateChain(alias);
        if (ret != null) {
            log.debug((Object)("looking for certificate chain by delegating... found " + ret.length));
            for (int i = 0; i < ret.length; ++i) {
                log.debug((Object)("getCertificateChain: " + ret[i].getSubjectDN()));
            }
            return ret;
        }
        log.debug((Object)"looking for certificate chain by delegating... not found");
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] prncpls) {
        log.debug((Object)("getClientAliases: " + keyType));
        String[] ret = this.keyManager.getClientAliases(keyType, prncpls);
        log.debug((Object)("getClientAliases found: " + ret.length));
        return ret;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey pk = this.keyManager.getPrivateKey(alias);
        log.debug((Object)("getPrivateKey for " + alias + ": " + (pk != null)));
        return pk;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] prncpls) {
        log.debug((Object)("getServerAliases: " + keyType));
        String[] ret = this.keyManager.getServerAliases(keyType, prncpls);
        log.debug((Object)("getServerAliases found: " + ret.length));
        return ret;
    }
}

