/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class BasicX509TrustManager
implements X509TrustManager {
    private static Logger log = Logger.getLogger(BasicX509TrustManager.class);
    private static final String TRUST_ALL_PROPERTY = BasicX509TrustManager.class.getName() + ".trust";
    private X509TrustManager delegate;

    public BasicX509TrustManager(X509TrustManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String str) throws CertificateException {
        if (xcs != null) {
            for (int i = 0; i < xcs.length; ++i) {
                log.debug((Object)("checkClientTrusted: " + xcs[i].getSubjectDN() + "," + str));
            }
        }
        this.delegate.checkClientTrusted(xcs, str);
        log.debug((Object)"delegate.checkClientTrusted: OK");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String str) throws CertificateException {
        if (xcs != null) {
            for (int i = 0; i < xcs.length; ++i) {
                log.debug((Object)("checkServerTrusted: " + xcs[i].getSubjectDN() + "," + str));
            }
        }
        if (System.getProperty(TRUST_ALL_PROPERTY) != null) {
            log.debug((Object)(TRUST_ALL_PROPERTY + " is set, trusting all server certificates"));
            return;
        }
        this.delegate.checkServerTrusted(xcs, str);
        log.debug((Object)"delegate.checkServerTrusted: OK");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] ret = this.delegate.getAcceptedIssuers();
        log.debug((Object)("deletage X509TrustManager knows " + ret.length + " accepted issuers"));
        return ret;
    }
}

