/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.util.ArgumentMap;
import java.io.File;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class CertCmdArgUtil {
    private static Logger log = Logger.getLogger(CertCmdArgUtil.class);
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String ARG_CERT = "cert";
    public static final String ARG_KEY = "key";
    public static final String DFT_CERTKEY_FILE = "/.ssl/cadcproxy.pem";
    public static final String DFT_CERT_FILE = "/.ssl/cadcproxy.crt";
    public static final String DFT_KEY_FILE = "/.ssl/cadcproxy.key";
    private static String userHome = System.getProperty("user.home");

    public static String getCertArgUsage() {
        return "   [--cert=<Cert File or Proxy Cert&Key PEM file> [--key=<Unencrypted Key File>]]";
    }

    private static File loadFile(String fn, boolean nullOnNotFound) {
        File f = new File(fn);
        if (!f.exists()) {
            if (nullOnNotFound) {
                return null;
            }
            throw new IllegalArgumentException(String.format("File %s does not exist.", fn));
        }
        if (!f.canRead()) {
            throw new IllegalArgumentException(String.format("File %s cannot be read.", fn));
        }
        return f;
    }

    private static Subject initSubjectByPem(String fnPem, boolean nullOnNotFound) {
        File certKeyFile = CertCmdArgUtil.loadFile(fnPem, nullOnNotFound);
        if (nullOnNotFound && certKeyFile == null) {
            return null;
        }
        return SSLUtil.createSubject(certKeyFile);
    }

    public static Subject initSubject(ArgumentMap argMap) {
        return CertCmdArgUtil.initSubject(argMap, false);
    }

    public static Subject initSubject(ArgumentMap argMap, boolean returnNullOnNotFound) {
        Subject subject = null;
        if (argMap.isSet(ARG_CERT)) {
            String strCertKey = argMap.getValue(ARG_CERT);
            subject = CertCmdArgUtil.initSubjectByPem(strCertKey, false);
        }
        return subject;
    }
}

