/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.Asn1Object;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class DerParser {
    protected InputStream in;

    public DerParser(InputStream in) throws IOException {
        this.in = in;
    }

    public DerParser(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public Asn1Object read() throws IOException {
        int tag = this.in.read();
        if (tag == -1) {
            throw new IOException("Invalid DER: stream too short, missing tag");
        }
        int length = this.getLength();
        byte[] value = new byte[length];
        int n = this.in.read(value);
        if (n < length) {
            throw new IOException("Invalid DER: stream too short, missing value");
        }
        Asn1Object o = new Asn1Object(tag, length, value);
        return o;
    }

    private int getLength() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IOException("Invalid DER: length missing");
        }
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        int num = i & 0x7F;
        if (i >= 255 || num > 4) {
            throw new IOException("Invalid DER: length field too big (" + i + ")");
        }
        byte[] bytes = new byte[num];
        int n = this.in.read(bytes);
        if (n < num) {
            throw new IOException("Invalid DER: length too short");
        }
        return new BigInteger(1, bytes).intValue();
    }
}

