/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.DNPrincipal;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.OpenIdPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public enum IdentityType {
    X500("X500"),
    OPENID("OpenID"),
    USERNAME("HTTP"),
    USERID("userID"),
    CADC("CADC"),
    NUMERICID("numericID"),
    COOKIE("sessionID"),
    ENTRY_DN("entryDN"),
    POSIX("POSIX");

    private final String value;
    public static final Map<String, IdentityType> principalIdentityMap;

    private IdentityType(String value) {
        this.value = value;
    }

    public static IdentityType toValue(String s) {
        for (IdentityType type : IdentityType.values()) {
            if (!type.value.equals(s)) continue;
            return type;
        }
        throw new IllegalArgumentException("invalid value: " + s);
    }

    public String getValue() {
        return this.value;
    }

    public int checksum() {
        return this.value.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.value + "]";
    }

    static {
        principalIdentityMap = new HashMap<String, IdentityType>(){
            {
                this.put(X500Principal.class.getSimpleName(), X500);
                this.put(HttpPrincipal.class.getSimpleName(), USERID);
                this.put(NumericPrincipal.class.getSimpleName(), NUMERICID);
                this.put(OpenIdPrincipal.class.getSimpleName(), OPENID);
                this.put(DNPrincipal.class.getSimpleName(), ENTRY_DN);
                this.put(PosixPrincipal.class.getSimpleName(), POSIX);
            }
        };
    }
}

