/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.UUID;

public class NumericPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 20140625143750L;
    private UUID numericID;

    public NumericPrincipal(UUID numericID) {
        this.numericID = numericID;
    }

    @Override
    public String getName() {
        return this.numericID.toString();
    }

    public UUID getUUID() {
        return this.numericID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.numericID.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericPrincipal)) {
            return false;
        }
        NumericPrincipal other = (NumericPrincipal)obj;
        return this.numericID.equals(other.numericID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        if (this.numericID.getMostSignificantBits() == 0L) {
            sb.append(this.numericID.getLeastSignificantBits());
        } else {
            sb.append(this.getName());
        }
        sb.append("]");
        return sb.toString();
    }
}

