/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.io.Serializable;
import java.net.URL;
import java.security.Principal;

public class OpenIdPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 202407041230L;
    private final String sub;
    private final URL issuer;

    public OpenIdPrincipal(URL issuer, String sub) {
        if (issuer == null) {
            throw new IllegalArgumentException("null issuer");
        }
        if (sub == null) {
            throw new IllegalArgumentException("null sub");
        }
        this.sub = sub;
        this.issuer = issuer;
    }

    @Override
    public String getName() {
        return this.sub;
    }

    public URL getIssuer() {
        return this.issuer;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sub.hashCode() + this.issuer.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdPrincipal)) {
            return false;
        }
        OpenIdPrincipal other = (OpenIdPrincipal)obj;
        return this.sub.equals(other.sub) && this.issuer.equals(other.issuer);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[issuer=" + this.getIssuer() + ", openID=" + this.getName() + "]";
    }
}

