/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.io.Serializable;
import java.security.Principal;

public class PosixPrincipal
implements Comparable<PosixPrincipal>,
Principal,
Serializable {
    private static final long serialVersionUID = 5423257890488724644L;
    private int uidNumber;
    public Integer defaultGroup;
    public String username;

    public PosixPrincipal(int uidNumber) {
        if (uidNumber < 0) {
            throw new IllegalArgumentException("invalid uidNumber " + uidNumber);
        }
        this.uidNumber = uidNumber;
    }

    @Override
    public String getName() {
        return Integer.toString(this.uidNumber);
    }

    public int getUidNumber() {
        return this.uidNumber;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.uidNumber;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PosixPrincipal other = (PosixPrincipal)obj;
        return this.uidNumber == other.uidNumber;
    }

    @Override
    public int compareTo(PosixPrincipal t) {
        return Integer.compare(this.uidNumber, t.uidNumber);
    }

    @Override
    public String toString() {
        return "PosixPrincipal [uidNumber=" + this.uidNumber + "," + this.defaultGroup + "," + this.username + "]";
    }
}

