/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.BasicX509KeyManager;
import ca.nrc.cadc.auth.BasicX509TrustManager;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;

public class SSLUtil {
    private static Logger log = Logger.getLogger(SSLUtil.class);
    private static final String SSL_PROTOCOL = "TLS";
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String KEYMANAGER_ALGORITHM = "SunX509";
    private static final String CERT_ALIAS = "opencadc_x509";
    private static final char[] THE_PASSWORD;

    @Deprecated
    public static void initSSL(File pemFile) {
        SSLSocketFactory sf = SSLUtil.getSocketFactory(pemFile);
        HttpsURLConnection.setDefaultSSLSocketFactory(sf);
    }

    public static SSLSocketFactory getSocketFactory(File pemFile) {
        X509CertificateChain chain;
        try {
            chain = SSLUtil.readPemCertificateAndKey(pemFile);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + pemFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + pemFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + pemFile, ex);
        }
        return SSLUtil.getSocketFactory(chain);
    }

    public static SSLSocketFactory getSocketFactory(Subject s) {
        X509CertificateChain chain = null;
        if (s != null) {
            Set<X509CertificateChain> certs = s.getPublicCredentials(X509CertificateChain.class);
            for (X509CertificateChain cc : certs) {
                if (cc.getKey() == null) continue;
                chain = cc;
                break;
            }
        }
        if (chain == null) {
            return null;
        }
        return SSLUtil.getSocketFactory(chain);
    }

    public static SSLSocketFactory getSocketFactory(X509CertificateChain chain) {
        KeyStore ts = null;
        KeyStore ks = null;
        if (chain != null) {
            ks = SSLUtil.getKeyStore(chain.getChain(), chain.getPrivateKey());
        }
        KeyManagerFactory kmf = SSLUtil.getKeyManagerFactory(ks);
        TrustManagerFactory tmf = SSLUtil.getTrustManagerFactory(ts);
        SSLContext ctx = SSLUtil.getContext(kmf, tmf, ks);
        SSLSocketFactory sf = ctx.getSocketFactory();
        return sf;
    }

    public static Subject createSubject(File certKeyFile) {
        try {
            X509CertificateChain certKey = SSLUtil.readPemCertificateAndKey(certKeyFile);
            return AuthenticationUtil.getSubject(certKey);
        }
        catch (InvalidKeySpecException ex) {
            throw new RuntimeException("failed to read RSA private key from " + certKeyFile, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create empty KeyStore", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read certificate file " + certKeyFile, ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException("failed to load certificate from file " + certKeyFile, ex);
        }
    }

    public static byte[] getCertificates(byte[] certBuf) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(certBuf)));
        String line = rdr.readLine();
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        int byteSize = 0;
        if (line != null && !(line = line.trim()).startsWith("---")) {
            byte[] tmp = Base64.decode(line);
            byteSize += tmp.length;
            certs.add(tmp);
        }
        if (byteSize == 0) {
            while (line != null) {
                StringBuilder base64 = new StringBuilder();
                if (line.startsWith("-----BEGIN CERTIFICATE-----")) {
                    line = rdr.readLine();
                    while (line != null && !line.startsWith("-----END CERTIFICATE-----")) {
                        base64.append(line.trim());
                        line = rdr.readLine();
                    }
                    if (!line.startsWith("-----END CERTIFICATE-----")) continue;
                    String encoded = base64.toString();
                    byte[] tmp = Base64.decode(encoded);
                    byteSize += tmp.length;
                    certs.add(tmp);
                    continue;
                }
                line = rdr.readLine();
            }
        }
        rdr.close();
        byte[] result = new byte[byteSize];
        byteSize = 0;
        for (byte[] cert : certs) {
            System.arraycopy(cert, 0, result, byteSize, cert.length);
            byteSize += cert.length;
        }
        return result;
    }

    public static X509Certificate[] readCertificateChain(File certFile) throws CertificateException, IOException {
        try {
            X509Certificate[] chain = SSLUtil.readCertificateChain(FileUtil.readFile(certFile));
            log.debug((Object)"X509 certificate is valid");
            return chain;
        }
        catch (CertificateException ex) {
            throw new RuntimeException("certificate from file " + certFile + " is not valid", ex);
        }
    }

    public static X509Certificate[] readCertificateChain(byte[] certBuf) throws CertificateException, IOException {
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(certBuf));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        while (istream.available() > 0) {
            Certificate cert = cf.generateCertificate(istream);
            certs.add(cert);
        }
        istream.close();
        X509Certificate[] chain = new X509Certificate[certs.size()];
        Iterator i = certs.iterator();
        int c = 0;
        while (i.hasNext()) {
            X509Certificate x509 = (X509Certificate)i.next();
            chain[c++] = x509;
            try {
                x509.checkValidity();
                log.debug((Object)"X509 certificate is valid");
            }
            catch (CertificateExpiredException exp) {
                log.debug((Object)"X509 certificate is expired");
            }
            catch (CertificateException ex) {
                throw new RuntimeException("certificate byte array is not valid", ex);
            }
        }
        return chain;
    }

    public static PrivateKey readPrivateKey(byte[] bytesPrivateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytesPrivateKey);
        PrivateKey pk = kf.generatePrivate(spec);
        return pk;
    }

    private static KeyStore getKeyStore(Certificate[] chain, PrivateKey pk) {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            try {
                ks.load(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ks.setKeyEntry(CERT_ALIAS, pk, THE_PASSWORD, chain);
            log.debug((Object)("added certificate chain to keystore: opencadc_x509," + pk + "," + THE_PASSWORD + "," + chain));
            return ks;
        }
        catch (KeyStoreException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof NoSuchAlgorithmException) {
                throw new IllegalArgumentException("Sorry, this implementation of Java, issued by " + System.getProperty("java.vendor") + ", does not support CADC Certificates.");
            }
            throw new RuntimeException("failed to find/load KeyStore of type JKS", ex);
        }
    }

    private static KeyManagerFactory getKeyManagerFactory(KeyStore keyStore) {
        String da = KEYMANAGER_ALGORITHM;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(da);
            kmf.init(keyStore, THE_PASSWORD);
            return kmf;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("failed to find KeyManagerFactory for " + da, ex);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("failed to init KeyManagerFactory", ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new RuntimeException("failed to init KeyManagerFactory", ex);
        }
    }

    private static TrustManagerFactory getTrustManagerFactory(KeyStore trustStore) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            tmf.init(trustStore);
            return tmf;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("BUG: failed to create TrustManagerFactory for algorithm=PKIX", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new RuntimeException("BUG: failed to create TrustManagerFactory for provider=SunJSSE", ex);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("failed to init trustManagerFactory", ex);
        }
    }

    private static SSLContext getContext(KeyManagerFactory kmf, TrustManagerFactory tmf, KeyStore ks) {
        try {
            KeyManager[] kms = kmf.getKeyManagers();
            for (int i = 0; i < kms.length; ++i) {
                BasicX509KeyManager wrapper = new BasicX509KeyManager((X509KeyManager)kms[i], CERT_ALIAS);
                kms[i] = wrapper;
            }
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                BasicX509TrustManager wrapper = new BasicX509TrustManager((X509TrustManager)tms[i]);
                tms[i] = wrapper;
            }
            SSLContext ctx = SSLContext.getInstance(SSL_PROTOCOL);
            log.debug((Object)("KMF returned " + kms.length + " KeyManagers"));
            log.debug((Object)("TMF returned " + tms.length + " TrustManagers"));
            ctx.init(kms, tms, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("failed to find SSLContext for TLS", ex);
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException("failed to init SSLContext", ex);
        }
    }

    private static void printKeyStoreInfo(KeyStore keystore) throws KeyStoreException {
        log.debug((Object)("Provider : " + keystore.getProvider().getName()));
        log.debug((Object)("Type : " + keystore.getType()));
        log.debug((Object)("Size : " + keystore.size()));
        Enumeration<String> en = keystore.aliases();
        while (en.hasMoreElements()) {
            System.out.println("Alias: " + en.nextElement());
        }
    }

    public static X509CertificateChain readPemCertificateAndKey(File pemFile) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, CertificateException {
        PEMParser parser = new PEMParser((Reader)new FileReader(pemFile));
        return SSLUtil.readPEM(parser);
    }

    public static X509CertificateChain readPemCertificateAndKey(byte[] data) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, CertificateException {
        InputStreamReader r = new InputStreamReader(new ByteArrayInputStream(data));
        PEMParser parser = new PEMParser((Reader)r);
        return SSLUtil.readPEM(parser);
    }

    private static X509CertificateChain readPEM(PEMParser parser) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, CertificateException {
        PrivateKey privateKey = null;
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        int byteSize = 0;
        Object obj = parser.readObject();
        while (obj != null) {
            log.debug((Object)("found: " + obj.getClass().getName()));
            if (obj instanceof PEMKeyPair) {
                PEMKeyPair pkp = (PEMKeyPair)obj;
                PrivateKeyInfo pki = pkp.getPrivateKeyInfo();
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                privateKey = converter.getPrivateKey(pki);
                log.debug((Object)(" private key: " + privateKey.getEncoded().length));
            } else if (obj instanceof PrivateKeyInfo) {
                PrivateKeyInfo pki = (PrivateKeyInfo)obj;
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
                privateKey = converter.getPrivateKey(pki);
                log.debug((Object)(" private key: " + privateKey.getEncoded().length));
            } else if (obj instanceof X509CertificateHolder) {
                X509CertificateHolder xch = (X509CertificateHolder)obj;
                byte[] bytes = xch.toASN1Structure().getEncoded("DER");
                certs.add(bytes);
                byteSize += bytes.length;
                log.debug((Object)(" certificate: " + bytes.length));
            } else if (obj instanceof PemObject) {
                PemObject po = (PemObject)obj;
                if ("certificate".equalsIgnoreCase(po.getType())) {
                    certs.add(po.getContent());
                    byteSize += po.getContent().length;
                    log.debug((Object)(" certificate: " + po.getContent().length));
                } else if ("rsa private key".equalsIgnoreCase(po.getType())) {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(po.getContent());
                    privateKey = keyFactory.generatePrivate(keySpec);
                    log.debug((Object)(" private key: " + po.getContent().length));
                } else {
                    log.warn((Object)("readPEM: unexpected PemObject type: " + po.getType() + " aka " + obj.getClass().getName()));
                }
            }
            obj = parser.readPemObject();
        }
        byte[] flat = new byte[byteSize];
        byteSize = 0;
        for (byte[] cert : certs) {
            System.arraycopy(cert, 0, flat, byteSize, cert.length);
            byteSize += cert.length;
        }
        X509Certificate[] chain = SSLUtil.readCertificateChain(flat);
        return new X509CertificateChain(chain, privateKey);
    }

    public static void validateSubject(Subject subject, Date date) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        if (subject != null) {
            Set<X509CertificateChain> certs = subject.getPublicCredentials(X509CertificateChain.class);
            if (certs.isEmpty()) {
                throw new CertificateException("No certificates associated with subject");
            }
            X509CertificateChain chain = certs.iterator().next();
            for (X509Certificate c : chain.getChain()) {
                if (date != null) {
                    c.checkValidity(date);
                    continue;
                }
                c.checkValidity();
            }
        }
    }

    public static void renewSubject(Subject currentSubject, File certificate) {
        Subject subject = SSLUtil.createSubject(certificate);
        currentSubject.getPrincipals().clear();
        currentSubject.getPrincipals().addAll(subject.getPrincipals());
        currentSubject.getPublicCredentials().clear();
        currentSubject.getPublicCredentials().addAll(subject.getPublicCredentials());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        THE_PASSWORD = CERT_ALIAS.toCharArray();
    }
}

