/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import java.util.Date;

public class SSOCookieCredential {
    private String ssoCookieValue;
    private String domain;
    private Date expiryDate;

    public SSOCookieCredential(String cookieValue, String domain, Date expiryDate) {
        this.ssoCookieValue = cookieValue;
        this.domain = domain;
        this.expiryDate = expiryDate;
    }

    public SSOCookieCredential(String cookieValue, String domain) {
        this(cookieValue, domain, null);
    }

    public String getSsoCookieValue() {
        return this.ssoCookieValue;
    }

    public String getDomain() {
        return this.domain;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public boolean isExpired() {
        boolean expired = false;
        if (this.expiryDate != null) {
            expired = this.expiryDate.before(new Date());
        }
        return expired;
    }

    public String toString() {
        String returnStr = this.getClass().getSimpleName() + "[" + this.domain + "," + this.ssoCookieValue;
        if (this.expiryDate != null) {
            returnStr = returnStr + ", " + this.expiryDate.toString();
        }
        return returnStr + "]";
    }
}

