/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.InvalidSignedTokenException;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.auth.SignedToken;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.util.PropertiesReader;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SSOCookieManager {
    public static final String DEFAULT_SSO_COOKIE_NAME = "CADC_SSO";
    public static final int SSO_COOKIE_LIFETIME_HOURS = 48;
    public static final URI SCOPE_URI = URI.create("sso:cadc+canfar");
    public static final String DOMAINS_PROP_FILE = "ac-domains.properties";
    private int offsetExpiryHours = 1;

    public final SignedToken parse(String value) throws InvalidSignedTokenException {
        if (value == null) {
            throw new IllegalArgumentException("value required");
        }
        try {
            return SignedToken.parse(value);
        }
        catch (Exception e) {
            throw new InvalidSignedTokenException("Bad token." + value);
        }
    }

    public final String generate(HttpPrincipal principal) throws InvalidKeyException, IOException {
        HashSet<Principal> principalSet = new HashSet<Principal>();
        principalSet.add(principal);
        return this.generate(principalSet);
    }

    public final String generate(Set<Principal> principalSet, URI scope) throws InvalidKeyException, IOException {
        return this.generate(principalSet, null, scope);
    }

    public final String generate(Set<Principal> principalSet, Date expiryDate, URI scope) throws InvalidKeyException, IOException {
        if (expiryDate == null) {
            expiryDate = this.getExpirationDate();
        }
        if (scope == null) {
            scope = SCOPE_URI;
        }
        List<String> domainList = null;
        PropertiesReader propReader = new PropertiesReader(DOMAINS_PROP_FILE);
        List<String> domainValues = propReader.getPropertyValues("domains");
        if (domainValues != null && domainValues.size() > 0) {
            domainList = Arrays.asList(domainValues.get(0).split(" "));
        }
        SignedToken token = new SignedToken(principalSet, scope, expiryDate, domainList);
        return SignedToken.format(token);
    }

    public final String generate(Set<Principal> principalSet) throws InvalidKeyException, IOException {
        return this.generate(principalSet, this.getExpirationDate(), null);
    }

    public Date getExpirationDate() {
        Calendar cal = this.getCurrentCalendar();
        cal.add(10, 48 * this.offsetExpiryHours);
        return cal.getTime();
    }

    public Calendar getCurrentCalendar() {
        return Calendar.getInstance(DateUtil.UTC);
    }

    public void setOffsetExpiryHours(int offsetExpiryHours) {
        this.offsetExpiryHours = offsetExpiryHours;
    }

    public List<SSOCookieCredential> getSSOCookieCredentials(String cookieValue) throws InvalidSignedTokenException {
        ArrayList<SSOCookieCredential> cookieList = new ArrayList<SSOCookieCredential>();
        SignedToken cookieToken = SignedToken.parse(cookieValue);
        for (String domain : cookieToken.getDomains()) {
            SSOCookieCredential nextCookie = new SSOCookieCredential(cookieValue, domain, cookieToken.getExpiryTime());
            cookieList.add(nextCookie);
        }
        return cookieList;
    }
}

