/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthorizationTokenPrincipal;
import ca.nrc.cadc.auth.BearerTokenPrincipal;
import ca.nrc.cadc.auth.CookiePrincipal;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.PrincipalExtractor;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.util.ArrayUtil;
import ca.nrc.cadc.util.StringUtil;
import java.security.AccessControlException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ServletPrincipalExtractor
implements PrincipalExtractor {
    private static final Logger log = Logger.getLogger(ServletPrincipalExtractor.class);
    public static final String CERT_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private final HttpServletRequest request;
    private X509CertificateChain chain;
    private Set<Principal> principals = new HashSet<Principal>();

    private ServletPrincipalExtractor() {
        this.request = null;
    }

    public ServletPrincipalExtractor(HttpServletRequest req) {
        this.request = req;
        X509Certificate[] ca = (X509Certificate[])this.request.getAttribute(CERT_REQUEST_ATTRIBUTE);
        if (!ArrayUtil.isEmpty(ca)) {
            this.chain = new X509CertificateChain(Arrays.asList(ca));
            if (this.chain != null) {
                this.principals.add(this.chain.getPrincipal());
            }
        }
        if (this.chain == null && "true".equals(System.getProperty(CERT_HEADER_ENABLE))) {
            String certString = req.getHeader("X-Client-Certificate");
            log.debug((Object)("X-Client-Certificate:\n" + certString + "\n"));
            if (certString != null && certString.length() > 0) {
                try {
                    byte[] certBytes = SSLUtil.getCertificates(certString.getBytes());
                    this.chain = new X509CertificateChain(SSLUtil.readCertificateChain(certBytes), null);
                    this.principals.add(this.chain.getPrincipal());
                }
                catch (Exception e) {
                    log.error((Object)"Failed to read certificate", (Throwable)e);
                    throw new AccessControlException("Failed to read certificate: " + e.getMessage());
                }
            }
        }
        Enumeration authTokens = this.request.getHeaders("Authorization");
        while (authTokens.hasMoreElements()) {
            String authToken = (String)authTokens.nextElement();
            if (BearerTokenPrincipal.isBearerToken(authToken).booleanValue()) {
                BearerTokenPrincipal bearerTokenPrincipal = new BearerTokenPrincipal(authToken);
                this.principals.add(bearerTokenPrincipal);
                continue;
            }
            String allowBasicATP = System.getProperty(PrincipalExtractor.ALLOW_BASIC);
            if (!"true".equals(allowBasicATP) && authToken.toLowerCase().startsWith("Basic".toLowerCase() + " ")) continue;
            AuthorizationTokenPrincipal principal = new AuthorizationTokenPrincipal("Authorization", authToken);
            this.principals.add(principal);
        }
        String httpUser = this.request.getRemoteUser();
        if (StringUtil.hasText(httpUser)) {
            this.principals.add(new HttpPrincipal(httpUser));
        }
        Cookie[] cookies = this.request.getCookies();
        log.debug((Object)("Request cookies: " + cookies));
        if (cookies != null) {
            for (Cookie ssoCookie : cookies) {
                if (!"CADC_SSO".equals(ssoCookie.getName()) || !StringUtil.hasText(ssoCookie.getValue())) continue;
                CookiePrincipal cookiePrincipal = new CookiePrincipal(ssoCookie.getName(), ssoCookie.getValue());
                this.principals.add(cookiePrincipal);
            }
        }
    }

    @Override
    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    @Override
    public X509CertificateChain getCertificateChain() {
        return this.chain;
    }
}

