/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.IdentityType;
import ca.nrc.cadc.auth.InvalidSignedTokenException;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.PosixPrincipal;
import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.RsaSignatureGenerator;
import ca.nrc.cadc.util.RsaSignatureVerifier;
import ca.nrc.cadc.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class SignedToken
implements Serializable {
    private static final Logger log = Logger.getLogger(SignedToken.class);
    private static final long serialVersionUID = 20180321000000L;
    private Set<Principal> identityPrincipals;
    public static String PROXY_LABEL = "proxyuser";
    public static String SCOPE_LABEL = "scope";
    public static String DOMAIN_LABEL = "domain";
    public static String USER_LABEL = "userid";
    public static String EXPIRY_LABEL = "expirytime";
    public static String SIGNATURE_LABEL = "signature";
    private Date expiryTime;
    private URI scope;
    private List<String> domains;
    public static final String FIELD_DELIM = "&";
    public static final String VALUE_DELIM = "=";

    public SignedToken(HttpPrincipal user, URI scope, Date expiryTime, List<String> domains) {
        if (user == null) {
            throw new IllegalArgumentException("User identity required");
        }
        this.addPrincipal(user);
        if (expiryTime == null) {
            throw new IllegalArgumentException("No expiry time");
        }
        this.expiryTime = expiryTime;
        this.scope = scope;
        this.setDomains(domains);
    }

    public SignedToken(Set<Principal> principals, URI scope, Date expiryTime, List<String> domains) {
        if (principals == null || principals.size() == 0) {
            throw new IllegalArgumentException("Identity principals required (ie http, x500, cadc internal)");
        }
        if (expiryTime == null) {
            throw new IllegalArgumentException("No expiry time");
        }
        this.addPrincipals(principals);
        this.expiryTime = expiryTime;
        this.scope = scope;
        this.setDomains(domains);
    }

    public static String format(SignedToken token) throws InvalidKeyException, IOException {
        StringBuilder sb = SignedToken.getContent(token);
        String toSign = sb.toString();
        log.debug((Object)("string to be signed: " + toSign));
        sb.append(FIELD_DELIM);
        sb.append(SIGNATURE_LABEL);
        sb.append(VALUE_DELIM);
        RsaSignatureGenerator su = new RsaSignatureGenerator();
        byte[] sig = su.sign(new ByteArrayInputStream(toSign.getBytes()));
        sb.append(new String(Base64.encode(sig)));
        return new String(Base64.encode(sb.toString().getBytes()));
    }

    private static StringBuilder getContent(SignedToken token) {
        StringBuilder sb = new StringBuilder();
        sb.append(EXPIRY_LABEL).append(VALUE_DELIM);
        sb.append(token.getExpiryTime().getTime());
        for (Principal prin : token.identityPrincipals) {
            String principalName = prin.getClass().getSimpleName();
            IdentityType principalIdentity = IdentityType.principalIdentityMap.get(principalName);
            if (principalIdentity.equals((Object)IdentityType.ENTRY_DN)) continue;
            sb.append(FIELD_DELIM);
            sb.append(principalIdentity.getValue());
            sb.append(VALUE_DELIM);
            sb.append(prin.getName());
        }
        HttpPrincipal user = token.getUser();
        if (StringUtil.hasText(user.getProxyUser())) {
            sb.append(FIELD_DELIM);
            sb.append(PROXY_LABEL);
            sb.append(VALUE_DELIM);
            sb.append(user.getProxyUser());
        }
        if (token.getScope() != null) {
            sb.append(FIELD_DELIM);
            sb.append(SCOPE_LABEL);
            sb.append(VALUE_DELIM);
            sb.append(token.getScope());
        }
        if (token.getDomains() != null) {
            for (String domain : token.getDomains()) {
                sb.append(FIELD_DELIM);
                sb.append(DOMAIN_LABEL);
                sb.append(VALUE_DELIM);
                sb.append(domain);
            }
        }
        log.debug((Object)("getContent: " + sb));
        return sb;
    }

    public static boolean isSignedToken(String text) {
        try {
            String val = Base64.decodeString(text);
            return val.contains(EXPIRY_LABEL);
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    public static SignedToken parse(String text) throws InvalidSignedTokenException {
        log.debug((Object)("parsing token: " + text));
        if (text.startsWith(EXPIRY_LABEL)) {
            String[] fields = text.split(FIELD_DELIM);
            return SignedToken.parse(fields, text);
        }
        return SignedToken.parseEncoded(text);
    }

    private static SignedToken parse(String[] fields, String cookieText) throws InvalidSignedTokenException {
        String userid = null;
        HashSet<Principal> principalSet = new HashSet<Principal>();
        String proxyUser = null;
        Date expirytime = null;
        URI scope = null;
        String signature = null;
        ArrayList<String> domains = new ArrayList<String>();
        try {
            for (String field : fields) {
                log.debug((Object)("Field: " + field));
                String key = field.substring(0, field.indexOf(VALUE_DELIM));
                String value = field.substring(field.indexOf(VALUE_DELIM) + 1);
                log.debug((Object)("key = value: " + key + VALUE_DELIM + value));
                if (key.equalsIgnoreCase(IdentityType.USERID.getValue())) {
                    userid = value;
                    continue;
                }
                if (key.equalsIgnoreCase(PROXY_LABEL)) {
                    proxyUser = value;
                    continue;
                }
                if (key.equalsIgnoreCase(IdentityType.X500.getValue().toLowerCase())) {
                    principalSet.add(new X500Principal(value));
                    continue;
                }
                if (key.equalsIgnoreCase(IdentityType.NUMERICID.getValue()) || key.equalsIgnoreCase(IdentityType.CADC.getValue())) {
                    principalSet.add(new NumericPrincipal(UUID.fromString(value)));
                    continue;
                }
                if (key.equalsIgnoreCase(IdentityType.POSIX.getValue())) {
                    principalSet.add(new PosixPrincipal(Integer.parseInt(value)));
                    continue;
                }
                if (key.equalsIgnoreCase(EXPIRY_LABEL)) {
                    expirytime = new Date(Long.valueOf(value));
                    continue;
                }
                if (key.equalsIgnoreCase(SCOPE_LABEL)) {
                    scope = new URI(value);
                    continue;
                }
                if (key.equalsIgnoreCase(SIGNATURE_LABEL)) {
                    signature = value;
                    continue;
                }
                if (!key.equalsIgnoreCase(DOMAIN_LABEL)) continue;
                domains.add(value);
            }
            if (userid != null && proxyUser != null) {
                principalSet.add(new HttpPrincipal(userid, proxyUser));
            } else if (userid != null) {
                principalSet.add(new HttpPrincipal(userid));
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidSignedTokenException("invalid numeric field", ex);
        }
        catch (URISyntaxException ex) {
            throw new InvalidSignedTokenException("invalid scope URI", ex);
        }
        if (signature == null) {
            throw new InvalidSignedTokenException("missing signature");
        }
        if (expirytime == null) {
            throw new InvalidSignedTokenException("missing expirytime");
        }
        Date now = new Date();
        if (now.getTime() > expirytime.getTime()) {
            throw new InvalidSignedTokenException("expired");
        }
        SignedToken.validateSignature(signature, cookieText);
        return new SignedToken(principalSet, scope, expirytime, domains);
    }

    private static SignedToken parseEncoded(String encodedToken) throws InvalidSignedTokenException {
        try {
            byte[] decodedBytes = Base64.decode(encodedToken);
            String decodedString = new String(decodedBytes);
            return SignedToken.parse(decodedString.split(FIELD_DELIM), decodedString);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSignedTokenException("failed to decode token", e);
        }
    }

    private static void validateSignature(String signatureString, String text) throws InvalidSignedTokenException {
        try {
            byte[] signature = Base64.decode(signatureString);
            RsaSignatureVerifier su = new RsaSignatureVerifier();
            String signatureSplitter = FIELD_DELIM + SIGNATURE_LABEL + VALUE_DELIM;
            String[] cookieNSignature = text.split(signatureSplitter);
            log.debug((Object)("string to be verified" + cookieNSignature[0]));
            boolean valid = su.verify(new ByteArrayInputStream(cookieNSignature[0].getBytes()), signature);
            if (!valid) {
                log.error((Object)("invalid signature: " + new String(signature)));
                throw new InvalidSignedTokenException("cannot verify signature");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"failed to verify DelegationToken signature", (Throwable)ex);
            throw new InvalidSignedTokenException("cannot verify signature", ex);
        }
    }

    public HttpPrincipal getUser() {
        return (HttpPrincipal)this.getPrincipalByClass(HttpPrincipal.class);
    }

    public <T extends Principal> T getPrincipalByClass(Class clazz) {
        for (Principal prin : this.identityPrincipals) {
            if (prin.getClass() != clazz) continue;
            return (T)prin;
        }
        return null;
    }

    public Date getExpiryTime() {
        return this.expiryTime;
    }

    public URI getScope() {
        return this.scope;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DelegationToken(").append(USER_LABEL).append(VALUE_DELIM);
        if (StringUtil.hasText(this.getUser().getProxyUser())) {
            sb.append(",").append(PROXY_LABEL).append(VALUE_DELIM);
            sb.append(this.getUser().getProxyUser());
        }
        sb.append(this.getUser());
        sb.append(",").append(SCOPE_LABEL).append(VALUE_DELIM);
        sb.append(this.getScope());
        sb.append(",startTime=");
        sb.append(this.getExpiryTime());
        for (String domain : this.domains) {
            sb.append(",").append(DOMAIN_LABEL).append(VALUE_DELIM).append(domain);
        }
        sb.append(")");
        return sb.toString();
    }

    private void setDomains(List<String> domains) {
        if (domains != null) {
            if (this.domains == null) {
                this.domains = new ArrayList<String>();
            }
            this.domains.addAll(domains);
        }
    }

    private void addPrincipal(Principal p) {
        if (p != null) {
            HashSet<Principal> prSet = new HashSet<Principal>();
            prSet.add(p);
            this.addPrincipals(prSet);
        }
    }

    private void addPrincipals(Set<Principal> principals) {
        if (principals != null) {
            if (this.identityPrincipals == null) {
                this.identityPrincipals = new HashSet<Principal>();
            }
            this.identityPrincipals.addAll(principals);
        }
    }

    public Set<Principal> getIdentityPrincipals() {
        return this.identityPrincipals;
    }
}

