/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthorizationToken;
import ca.nrc.cadc.auth.AuthorizationTokenPrincipal;
import ca.nrc.cadc.auth.CookiePrincipal;
import ca.nrc.cadc.auth.InvalidSignedTokenException;
import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.auth.SSOCookieManager;
import ca.nrc.cadc.auth.SignedToken;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class TokenValidator {
    private static Logger log = Logger.getLogger(TokenValidator.class);

    public static Subject validateTokens(Subject subject) throws NotAuthenticatedException {
        Set<CookiePrincipal> cookiePrincipals = subject.getPrincipals(CookiePrincipal.class);
        log.debug((Object)("validateTokens: found " + cookiePrincipals.size() + " cookie principals"));
        if (!cookiePrincipals.isEmpty()) {
            SSOCookieManager ssoCookieManager = new SSOCookieManager();
            for (CookiePrincipal cookiePrincipal : cookiePrincipals) {
                try {
                    SignedToken cookieToken = ssoCookieManager.parse(cookiePrincipal.getValue());
                    subject.getPrincipals().addAll(cookieToken.getIdentityPrincipals());
                    List<SSOCookieCredential> cookieCredentialList = ssoCookieManager.getSSOCookieCredentials(cookiePrincipal.getValue());
                    log.debug((Object)("Adding " + cookieCredentialList.size() + " cookie credentials to subject"));
                    subject.getPublicCredentials().addAll(cookieCredentialList);
                    subject.getPrincipals().remove(cookiePrincipal);
                }
                catch (InvalidSignedTokenException ex) {
                    throw new NotAuthenticatedException("invalid cookie: " + ex.getMessage(), ex);
                }
            }
        }
        Set<AuthorizationTokenPrincipal> tokenPrincipals = subject.getPrincipals(AuthorizationTokenPrincipal.class);
        log.debug((Object)("validateTokens: found " + tokenPrincipals.size() + " token principals"));
        for (AuthorizationTokenPrincipal authorizationTokenPrincipal : tokenPrincipals) {
            log.debug((Object)("header key: " + authorizationTokenPrincipal.getHeaderKey()));
            log.debug((Object)("header value: " + authorizationTokenPrincipal.getHeaderValue()));
            String credentials = null;
            String challengeType = null;
            if (!"Authorization".equals(authorizationTokenPrincipal.getHeaderKey())) continue;
            int spaceIndex = authorizationTokenPrincipal.getHeaderValue().indexOf(" ");
            if (spaceIndex == -1) {
                throw new NotAuthenticatedException(challengeType, NotAuthenticatedException.AuthError.INVALID_REQUEST, "missing authorization challenge");
            }
            challengeType = authorizationTokenPrincipal.getHeaderValue().substring(0, spaceIndex).trim();
            if (!"Bearer".equalsIgnoreCase(challengeType)) continue;
            credentials = authorizationTokenPrincipal.getHeaderValue().substring(spaceIndex + 1).trim();
            try {
                if (!SignedToken.isSignedToken(credentials)) continue;
                SignedToken validatedToken = SignedToken.parse(credentials);
                subject.getPrincipals().addAll(validatedToken.getIdentityPrincipals());
                AuthorizationToken authToken = new AuthorizationToken(challengeType, credentials, validatedToken.getDomains(), validatedToken.getScope());
                log.debug((Object)"Adding token credential to subject, removing token principal");
                subject.getPublicCredentials().add(authToken);
                subject.getPrincipals().remove(authorizationTokenPrincipal);
            }
            catch (Exception ex) {
                throw new NotAuthenticatedException(challengeType, NotAuthenticatedException.AuthError.INVALID_TOKEN, ex.getMessage(), ex);
            }
        }
        return subject;
    }
}

