/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.NotAuthenticatedException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;

public class X500IdentityManager
implements IdentityManager {
    @Override
    public Subject validate(Subject subject) throws NotAuthenticatedException {
        return subject;
    }

    @Override
    public Subject augment(Subject subject) {
        return subject;
    }

    @Override
    public String toDisplayString(Subject subject) {
        Set<X500Principal> principals;
        Iterator<X500Principal> iterator;
        if (subject != null && (iterator = (principals = subject.getPrincipals(X500Principal.class)).iterator()).hasNext()) {
            X500Principal principal = iterator.next();
            return AuthenticationUtil.canonizeDistinguishedName(principal.getName());
        }
        return null;
    }

    @Override
    public Object toOwner(Subject subject) {
        return this.toDisplayString(subject);
    }

    @Override
    public Subject toSubject(Object owner) {
        String str = (String)owner;
        X500Principal p = new X500Principal(str);
        HashSet<X500Principal> pset = new HashSet<X500Principal>();
        pset.add(p);
        return new Subject(false, pset, new HashSet(), new HashSet());
    }

    @Override
    public Set<URI> getSecurityMethods() {
        TreeSet<URI> ret = new TreeSet<URI>();
        ret.add(URI.create("ivo://ivoa.net/sso#tls-with-certificate"));
        ret.add(URI.create("ivo://ivoa.net/sso#anon"));
        return ret;
    }
}

