/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db;

import ca.nrc.cadc.util.HashUtil;
import java.io.Serializable;

public class ConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 201103241000L;
    private String server;
    private String database;
    private String username;
    private String password;
    private String driver;
    private String url;

    public ConnectionConfig(String server, String database, String username, String password, String driver, String url) {
        this.server = server;
        this.database = database;
        this.username = username;
        this.password = password;
        this.driver = driver;
        this.url = url;
    }

    void setDriver(String s) {
        this.driver = s;
    }

    void setURL(String s) {
        this.url = s;
    }

    public final boolean matches(String server, String database) {
        return this.matches(server, database, true);
    }

    public final boolean matches(String server, String database, boolean matchWildcard) {
        boolean dbMatch = matchWildcard ? this.database.equals(database) || this.isWildcardDatabase() : this.database.equals(database);
        return this.server.equals(server) && dbMatch;
    }

    public final boolean isWildcardDatabase() {
        return this.database.equals("*");
    }

    public String getServer() {
        return this.server;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getURL() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionConfig that = (ConnectionConfig)o;
        if (this.database != null ? !this.database.equals(that.database) : that.database != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.username == null ? that.username != null : !this.username.equals(that.username));
    }

    public int hashCode() {
        int result = HashUtil.hash(23, this.server);
        result = HashUtil.hash(result, this.database);
        result = HashUtil.hash(result, this.username);
        result = HashUtil.hash(result, this.password);
        result = HashUtil.hash(result, this.driver);
        return HashUtil.hash(result, this.url);
    }
}

