/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db;

import ca.nrc.cadc.db.ConnectionConfig;
import ca.nrc.cadc.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DBConfig
implements Serializable {
    private static final long serialVersionUID = 201103241000L;
    public static final String COMMENT_INDICATOR = "#";
    private List<ConnectionConfig> lookup = new ArrayList<ConnectionConfig>();

    public DBConfig() throws FileNotFoundException, IOException {
        this(new File(System.getProperty("user.home") + "/.dbrc"));
    }

    public DBConfig(File dbrc) throws FileNotFoundException, IOException {
        LineNumberReader r = new LineNumberReader(new FileReader(dbrc));
        boolean eof = false;
        int n = 0;
        while (!eof) {
            String s = r.readLine();
            boolean bl = eof = s == null;
            if (!eof) {
                if ("".equals(s.trim()) || StringUtil.startsWith(s, COMMENT_INDICATOR)) continue;
                ++n;
                StringTokenizer st = new StringTokenizer(s);
                if (!st.hasMoreTokens()) {
                    throw new IOException("DBConfig: .dbrc syntax error on line " + n);
                }
                String srv = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new IOException("DBConfig: .dbrc syntax error on line " + n);
                }
                String db = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new IOException("DBConfig: .dbrc syntax error on line " + n);
                }
                String usr = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new IOException("DBConfig: .dbrc syntax error on line " + n);
                }
                String pwd = st.nextToken();
                String jdbc_driver = st.hasMoreTokens() ? st.nextToken() : null;
                String jdbc_url = st.hasMoreTokens() ? st.nextToken() : null;
                this.lookup.add(new ConnectionConfig(srv, db, usr, pwd, jdbc_driver, jdbc_url));
            }
            this.setDrivers();
        }
    }

    public ConnectionConfig getConnectionConfig(String server, String database) throws NoSuchElementException {
        ConnectionConfig cc = this.find(server, database);
        if (cc != null) {
            return cc;
        }
        throw new NoSuchElementException("connecting to '" + server + "/" + database + "' not supported");
    }

    public boolean isDB2(String server, String database) {
        return this.getJDBCURL(server, database).indexOf("db2") >= 0;
    }

    public boolean isSybase(String server, String database) {
        return this.getJDBCURL(server, database).indexOf("sybase") >= 0;
    }

    public ConnectionConfig[] getConfigurations() {
        if (this.lookup == null) {
            return null;
        }
        ConnectionConfig[] configs = new ConnectionConfig[this.lookup.size()];
        Object[] objects = this.lookup.toArray();
        for (int i = 0; i < objects.length; ++i) {
            configs[i] = (ConnectionConfig)objects[i];
        }
        return configs;
    }

    private String getJDBCURL(String server, String db) {
        ConnectionConfig cc = this.getConnectionConfig(server, db);
        if (cc == null) {
            return "";
        }
        return cc.getURL();
    }

    private ConnectionConfig find(String s, String d) {
        for (ConnectionConfig cc : this.lookup) {
            if (!cc.matches(s, d, false)) continue;
            return cc;
        }
        for (ConnectionConfig cc : this.lookup) {
            if (!cc.matches(s, d, true)) continue;
            return cc;
        }
        return null;
    }

    private void setDrivers() {
        ListIterator<ConnectionConfig> i = this.lookup.listIterator();
        while (i.hasNext()) {
            ConnectionConfig cc = i.next();
            if (cc.getDriver() != null) continue;
            ConnectionConfig cc2 = this.find(cc.getServer(), "*");
            if (cc2 == null) {
                i.remove();
                continue;
            }
            cc.setDriver(cc2.getDriver());
            cc.setURL(cc2.getURL());
        }
    }
}

