/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db;

import ca.nrc.cadc.db.ConnectionConfig;
import ca.nrc.cadc.db.DBConfigException;
import ca.nrc.cadc.db.StandaloneContextFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.dao.TransientDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.transaction.CannotCreateTransactionException;

public class DBUtil {
    private static final Logger log = Logger.getLogger(DBUtil.class);
    public static String DEFAULT_JNDI_ENV_CONTEXT = "java:/comp/env";

    public static DataSource getDataSource(ConnectionConfig config) throws DBConfigException {
        return DBUtil.getDataSource(config, true, true);
    }

    public static DataSource getDataSource(ConnectionConfig config, boolean suppressClose, boolean test) throws DBConfigException {
        try {
            log.debug((Object)("server: " + config.getServer()));
            log.debug((Object)("driver: " + config.getDriver()));
            log.debug((Object)("url: " + config.getURL()));
            log.debug((Object)("database: " + config.getDatabase()));
            Class.forName(config.getDriver());
            SingleConnectionDataSource ds = new SingleConnectionDataSource(config.getURL(), config.getUsername(), config.getPassword(), suppressClose);
            Properties props = new Properties();
            props.setProperty("APPLICATIONNAME", DBUtil.getMainClass());
            ds.setConnectionProperties(props);
            if (test) {
                DBUtil.testDS((DataSource)ds, true);
            }
            return ds;
        }
        catch (ClassNotFoundException ex) {
            throw new DBConfigException("failed to load JDBC driver: " + config.getDriver(), ex);
        }
        catch (SQLException ex) {
            throw new DBConfigException("failed to open connection: " + config.getURL(), ex);
        }
    }

    public static DataSource getDataSource(String dataSource) throws NamingException {
        return DBUtil.findJNDIDataSource(dataSource);
    }

    public static void createJNDIDataSource(String dataSourceName, ConnectionConfig config) throws NamingException {
        DBUtil.createJNDIDataSource(dataSourceName, DEFAULT_JNDI_ENV_CONTEXT, config);
    }

    public static void createJNDIDataSource(String dataSourceName, String envContextName, ConnectionConfig config) throws NamingException {
        log.debug((Object)("createDataSource: " + dataSourceName + " START"));
        StandaloneContextFactory.initJNDI();
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup(envContextName);
        if (envContext == null) {
            envContext = initContext.createSubcontext(envContextName);
        }
        log.debug((Object)("env: " + envContext));
        DataSource ds = DBUtil.getDataSource(config, true, true);
        envContext.bind(dataSourceName, (Object)ds);
        log.debug((Object)("createDataSource: " + dataSourceName + " DONE"));
    }

    public static void createJNDIDataSource(String dataSourceName, PoolConfig config) throws NamingException {
        log.debug((Object)("createJNDIDataSource: " + dataSourceName + " POOL START"));
        StandaloneContextFactory.initJNDI();
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup(DEFAULT_JNDI_ENV_CONTEXT);
        if (envContext == null) {
            envContext = initContext.createSubcontext(DEFAULT_JNDI_ENV_CONTEXT);
        }
        log.debug((Object)("env: " + envContext));
        DataSource dataSource = DBUtil.createPool(config);
        envContext.bind(dataSourceName, (Object)dataSource);
        log.debug((Object)("createJNDIDataSource: " + dataSourceName + " POOL DONE"));
    }

    public static DataSource findJNDIDataSource(String dataSource) throws NamingException {
        return DBUtil.findJNDIDataSource(dataSource, DEFAULT_JNDI_ENV_CONTEXT);
    }

    public static DataSource findJNDIDataSource(String dataSource, String envContextName) throws NamingException {
        log.debug((Object)("getDataSource: " + dataSource));
        InitialContext initContext = new InitialContext();
        Context envContext = (Context)initContext.lookup(envContextName);
        DataSource ds = (DataSource)envContext.lookup(dataSource);
        return ds;
    }

    public static boolean isTransientDBException(Throwable t) {
        return t instanceof TransientDataAccessException || t instanceof CannotGetJdbcConnectionException || t instanceof CannotCreateTransactionException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testDS(DataSource ds, boolean keepOpen) throws SQLException {
        Connection con = null;
        try {
            con = ds.getConnection();
            DatabaseMetaData meta = con.getMetaData();
            if (!log.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                return;
            }
            log.debug((Object)("connected to server: " + meta.getDatabaseProductName() + " " + meta.getDatabaseMajorVersion() + "." + meta.getDatabaseMinorVersion() + " driver: " + meta.getDriverName() + " " + meta.getDriverMajorVersion() + "." + meta.getDriverMinorVersion()));
        }
        finally {
            if (!keepOpen && con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getMainClass() {
        String ret = "java";
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException rex) {
            StackTraceElement[] st = rex.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                if (!st[i].getClassName().startsWith("ca.nrc.cadc.")) continue;
                ret = st[i].getClassName();
            }
            ret = DBUtil.shortenClassName(ret);
            return ret;
        }
    }

    private static String shortenClassName(String cname) {
        String ret = cname;
        if (ret.startsWith("ca.nrc.cadc.")) {
            ret = ret.substring("ca.nrc.cadc.".length());
        }
        while (ret.length() > 30) {
            int ii = ret.indexOf(46);
            if (ii > 0) {
                ret = ret.substring(ii + 1);
                continue;
            }
            ret = ret.substring(0, 30);
        }
        return ret;
    }

    private static DataSource createPool(PoolConfig config) {
        try {
            Class.forName(config.cc.getDriver());
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(config.cc.getURL(), config.cc.getUsername(), config.cc.getPassword());
            ObjectName jmxObjectName = null;
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, jmxObjectName);
            poolableConnectionFactory.setValidationQuery(config.validationQuery);
            GenericObjectPool objectPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
            objectPool.setMinIdle(config.poolSize);
            objectPool.setMaxIdle(config.poolSize);
            objectPool.setMaxTotal(config.poolSize);
            objectPool.setTestOnBorrow(true);
            objectPool.setTestOnCreate(true);
            objectPool.setMaxWaitMillis(config.maxWait);
            poolableConnectionFactory.setPool((ObjectPool)objectPool);
            PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)objectPool);
            return dataSource;
        }
        catch (ClassNotFoundException ex) {
            throw new DBConfigException("failed to load JDBC driver: " + config.cc.getDriver(), ex);
        }
        catch (Exception ex) {
            throw new DBConfigException("failed to init connection pool: " + config.cc.getURL(), ex);
        }
    }

    public static class PoolConfig {
        private ConnectionConfig cc;
        private int poolSize;
        private long maxWait;
        private String validationQuery;

        public PoolConfig(ConnectionConfig cc, int poolSize, long maxWait, String validationQuery) {
            this.cc = cc;
            this.poolSize = poolSize;
            this.maxWait = maxWait;
            this.validationQuery = validationQuery;
        }
    }
}

