/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db;

import ca.nrc.cadc.db.TransactionManager;
import java.util.Deque;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DatabaseTransactionManager
implements TransactionManager {
    private static final Logger log = Logger.getLogger(DatabaseTransactionManager.class);
    private DataSourceTransactionManager writeTxnManager;
    private final TransactionDefinition defaultTxnDef = new DefaultTransactionDefinition();
    private final TransactionDefinition nested = new DefaultTransactionDefinition(6);
    private final Deque<Txn> transactions = new LinkedList<Txn>();

    private DatabaseTransactionManager() {
    }

    public DatabaseTransactionManager(DataSource ds) {
        this.writeTxnManager = new DataSourceTransactionManager(ds);
    }

    @Override
    public boolean isOpen() {
        return !this.transactions.isEmpty();
    }

    @Override
    public void startTransaction() {
        TransactionDefinition defn;
        if (this.transactions.isEmpty()) {
            log.debug((Object)"startTransaction: default");
            defn = this.defaultTxnDef;
        } else if (this.writeTxnManager.isNestedTransactionAllowed()) {
            log.debug((Object)"startTransaction: nested");
            defn = this.nested;
        } else {
            throw new RuntimeException("nested transactions not supported by current configuration");
        }
        Txn txn = new Txn(this.writeTxnManager.getTransaction(defn), true);
        this.transactions.push(txn);
        log.debug((Object)("startTransaction: " + this.transactions.size()));
    }

    @Override
    public void commitTransaction() {
        if (this.transactions.isEmpty()) {
            throw new IllegalStateException("no transaction in progress");
        }
        Txn txn = this.transactions.pop();
        if (txn.doCommit) {
            log.debug((Object)"commitTransaction");
            this.writeTxnManager.commit(txn.status);
            log.debug((Object)"commitTransaction: OK");
        } else {
            log.debug((Object)"commitTransaction - skip");
        }
        log.debug((Object)("commitTransaction: " + this.transactions.size()));
    }

    @Override
    public void rollbackTransaction() {
        if (this.transactions.isEmpty()) {
            throw new IllegalStateException("no transaction in progress");
        }
        Txn txn = this.transactions.pop();
        if (txn.doCommit) {
            log.debug((Object)"rollbackTransaction");
            this.writeTxnManager.rollback(txn.status);
            log.debug((Object)"rollbackTransaction: OK");
        } else {
            log.debug((Object)"rollbackTransaction - skip");
        }
        log.debug((Object)("rollbackTransaction: " + this.transactions.size()));
    }

    private class Txn {
        boolean doCommit;
        TransactionStatus status;

        Txn(TransactionStatus status, boolean doCommit) {
            this.status = status;
            this.doCommit = doCommit;
        }
    }
}

