/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db.mappers;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.util.HexUtil;
import java.net.URI;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;

public class JdbcMapUtil {
    private static Logger log = Logger.getLogger(JdbcMapUtil.class);

    public static String formatSQL(String[] sql) {
        StringBuilder sb = new StringBuilder();
        for (String s : sql) {
            sb.append("\n");
            sb.append(JdbcMapUtil.formatSQL(s));
        }
        return sb.toString();
    }

    public static String formatSQL(String sql) {
        sql = sql.replaceAll("SELECT ", "\nSELECT ");
        sql = sql.replaceAll("FROM ", "\nFROM ");
        sql = sql.replaceAll("LEFT ", "\n  LEFT ");
        sql = sql.replaceAll("RIGHT ", "\n  RIGHT ");
        sql = sql.replaceAll("WHERE ", "\nWHERE ");
        sql = sql.replaceAll("AND ", "\n  AND ");
        sql = sql.replaceAll("OR ", "\n  OR ");
        sql = sql.replaceAll("ORDER", "\nORDER");
        sql = sql.replaceAll("GROUP ", "\nGROUP ");
        sql = sql.replaceAll("HAVING ", "\nHAVING ");
        sql = sql.replaceAll("UNION ", "\nUNION ");
        return sql;
    }

    public static URI getURI(ResultSet rs, int col) throws SQLException {
        String o = rs.getString(col);
        if (o == null) {
            return null;
        }
        try {
            return new URI(o);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to URI", t);
        }
    }

    public static Boolean getBoolean(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        Integer i = null;
        if (o instanceof Integer) {
            i = (Integer)o;
        } else if (o instanceof Number) {
            i = ((Number)o).intValue();
        }
        if (i != null) {
            if (i == 0) {
                return Boolean.FALSE;
            }
            if (i == 1) {
                return Boolean.TRUE;
            }
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to Boolean");
    }

    public static Integer getInteger(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to Integer");
    }

    public static Long getLong(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        return JdbcMapUtil.objectToLong(o);
    }

    public static UUID getUUID(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof UUID) {
            return (UUID)o;
        }
        if (o instanceof Long) {
            return new UUID(0L, (Long)o);
        }
        if (o instanceof Number) {
            return new UUID(0L, ((Number)o).longValue());
        }
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (b.length < 16) {
                byte[] bb = new byte[16];
                System.arraycopy(b, 0, bb, 0, b.length);
                b = bb;
            }
            long msb = HexUtil.toLong(b, 0);
            long lsb = HexUtil.toLong(b, 8);
            return new UUID(msb, lsb);
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to UUID");
    }

    public static Float getFloat(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to Float");
    }

    public static Double getDouble(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        return JdbcMapUtil.objectToDouble(o);
    }

    private static Double objectToDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to Double");
    }

    private static Long objectToLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to Long");
    }

    public static String[] getTextArray(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof Array) {
            Array a = (Array)o;
            o = a.getArray();
        }
        if (o instanceof String[]) {
            String[] ao = (String[])o;
            return ao;
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to String[]");
    }

    public static double[] getDoubleArray(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof Array) {
            Array a = (Array)o;
            Object[] ao = (Object[])a.getArray();
            double[] ret = new double[ao.length];
            for (int i = 0; i < ao.length; ++i) {
                ret[i] = JdbcMapUtil.objectToDouble(ao[i]);
            }
            return ret;
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to double[]");
    }

    public static long[] getLongArray(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof Array) {
            Array a = (Array)o;
            Object[] ao = (Object[])a.getArray();
            long[] ret = new long[ao.length];
            for (int i = 0; i < ao.length; ++i) {
                ret[i] = JdbcMapUtil.objectToLong(ao[i]);
            }
            return ret;
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to long[]");
    }

    public static Date getDate(ResultSet rs, int col, Calendar cal) throws SQLException {
        Timestamp o = rs.getTimestamp(col, cal);
        return DateUtil.toDate(o);
    }

    public static byte[] getByteArray(ResultSet rs, int col) throws SQLException {
        Object o = rs.getObject(col);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new UnsupportedOperationException("converting " + o.getClass().getName() + " " + o + " to byte[]");
    }
}

