/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db.version;

import ca.nrc.cadc.db.DatabaseTransactionManager;
import ca.nrc.cadc.db.version.KeyValue;
import ca.nrc.cadc.db.version.ModelVersion;
import ca.nrc.cadc.db.version.ModelVersionDAO;
import ca.nrc.cadc.net.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class InitDatabase {
    private static final Logger log = Logger.getLogger(InitDatabase.class);
    private final String modelName;
    private final String modelVersion;
    private final String prevModelVersion;
    protected final List<String> createSQL = new ArrayList<String>();
    protected final List<String> upgradeSQL = new ArrayList<String>();
    protected final List<String> maintenanceSQL = new ArrayList<String>();
    private final DataSource dataSource;
    private final String database;
    private final String schema;

    public InitDatabase(DataSource dataSource, String database, String schema, String modelName, String modelVersion, String prevModelVersion) {
        this.assertNotNull("dataSource", dataSource);
        this.assertNotNull("modelName", modelName);
        this.assertNotNull("modelVersion", modelVersion);
        this.assertNotNull("prevModelVersion", prevModelVersion);
        this.dataSource = dataSource;
        this.modelName = modelName;
        this.modelVersion = modelVersion;
        this.prevModelVersion = prevModelVersion;
        this.database = database;
        this.schema = schema;
    }

    public InitDatabase(DataSource dataSource, String database, String schema, String modelName, String modelVersion) {
        this.assertNotNull("dataSource", dataSource);
        this.assertNotNull("modelName", modelName);
        this.assertNotNull("modelVersion", modelVersion);
        this.dataSource = dataSource;
        this.modelName = modelName;
        this.modelVersion = modelVersion;
        this.database = database;
        this.schema = schema;
        this.prevModelVersion = null;
    }

    private void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(InitDatabase.class.getSimpleName() + ": " + name + " cannot be null");
        }
    }

    String getVersion() {
        ModelVersionDAO vdao = new ModelVersionDAO(this.dataSource, this.database, this.schema);
        KeyValue cur = vdao.get(this.modelName);
        if (cur != null) {
            return cur.value;
        }
        return null;
    }

    public boolean doInit() {
        log.debug((Object)("doInit: " + this.modelName + " " + this.modelVersion));
        long t = System.currentTimeMillis();
        String prevVersion = null;
        DatabaseTransactionManager txn = new DatabaseTransactionManager(this.dataSource);
        JdbcTemplate jdbc = new JdbcTemplate(this.dataSource);
        try {
            KeyValue cur;
            boolean createTables = false;
            List<Object> ddls = new ArrayList();
            ModelVersionDAO vdao = new ModelVersionDAO(this.dataSource, this.database, this.schema);
            if (this.tableInDatabase()) {
                log.debug((Object)("table exists: " + this.modelName));
                cur = vdao.get(this.modelName);
                log.debug((Object)("found: " + cur));
                if (cur != null) {
                    if (this.modelVersion.equals(cur.value)) {
                        log.debug((Object)"doInit: already up to date - nothing to do");
                        boolean bl = false;
                        return bl;
                    }
                    if (this.prevModelVersion == null || this.prevModelVersion.equals(cur.value)) {
                        log.debug((Object)"doInit: possible to update - proceeding");
                    } else if (cur.value != null) {
                        throw new UnsupportedOperationException("doInit: cannot convert version " + cur.value + " (DB) to " + this.modelVersion + " (software)");
                    }
                } else {
                    log.debug((Object)"doInit: possible to create - proceeding");
                    createTables = true;
                    cur = new KeyValue(this.modelName);
                    ddls = this.createSQL;
                }
            } else {
                log.debug((Object)"doInit: possible to create - proceeding");
                createTables = true;
                cur = new KeyValue(this.modelName);
                ddls = this.createSQL;
            }
            txn.startTransaction();
            if (cur != null && !createTables) {
                cur = vdao.lock(this.modelName);
                if (this.modelVersion.equals(cur.value)) {
                    log.debug((Object)"doInit: already up to date - nothing to do");
                } else if (this.prevModelVersion == null || this.prevModelVersion.equals(cur.value)) {
                    ddls = this.upgradeSQL;
                } else {
                    throw new UnsupportedOperationException("doInit: cannot convert version " + cur.value + " (DB) to " + this.modelVersion + " (software)");
                }
            }
            boolean ret = false;
            if (!ddls.isEmpty()) {
                for (String string : ddls) {
                    log.info((Object)("process file: " + string));
                    List<String> statements = this.parseDDL(string, this.schema);
                    for (String sql : statements) {
                        log.info((Object)("execute statement:\n" + sql));
                        jdbc.execute(sql);
                    }
                }
                prevVersion = createTables ? this.modelVersion : cur.value;
                cur.value = this.modelVersion;
                vdao.put(cur);
                ret = true;
            }
            txn.commitTransaction();
            long dt = System.currentTimeMillis() - t;
            log.debug((Object)("doInit: " + this.modelName + " " + prevVersion + " to " + this.modelVersion + " " + dt + "ms"));
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException ex) {
            if (txn.isOpen()) {
                try {
                    txn.rollbackTransaction();
                }
                catch (Exception oops) {
                    log.error((Object)"failed to rollback transaction", (Throwable)oops);
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            log.debug((Object)"epic fail", (Throwable)ex);
            if (txn.isOpen()) {
                try {
                    txn.rollbackTransaction();
                }
                catch (Exception oops) {
                    log.error((Object)"failed to rollback transaction", (Throwable)oops);
                }
            }
            throw new RuntimeException("failed to init database", ex);
        }
        finally {
            if (txn.isOpen()) {
                log.error((Object)"BUG: open transaction in finally");
                try {
                    txn.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)"failed to rollback transaction in finally", (Throwable)ex);
                }
            }
        }
    }

    public boolean doMaintenance(Date lastModified, String tag) {
        log.debug((Object)("doMaintenance: " + this.modelName + " " + this.modelVersion));
        long t = System.currentTimeMillis();
        Object prevVersion = null;
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified cannot be null");
        }
        DatabaseTransactionManager txn = new DatabaseTransactionManager(this.dataSource);
        JdbcTemplate jdbc = new JdbcTemplate(this.dataSource);
        try {
            ModelVersionDAO vdao = new ModelVersionDAO(this.dataSource, this.database, this.schema);
            KeyValue cur = vdao.get(this.modelName);
            log.debug((Object)("found: " + cur));
            if (cur == null) {
                throw new ResourceNotFoundException("ModelVersion not found: " + this.modelName);
            }
            if (lastModified.after(cur.lastModified)) {
                if (!this.modelVersion.equals(cur.value)) {
                    throw new UnsupportedOperationException("doMaintenance: cannot operate on " + cur.value + " (DB) with " + this.modelVersion + " (software)");
                }
            } else {
                boolean bl = false;
                return bl;
            }
            log.debug((Object)"doMaintenance: possible to update - proceeding");
            txn.startTransaction();
            cur = vdao.lock(this.modelName);
            if (lastModified.after(cur.lastModified)) {
                if (!this.modelVersion.equals(cur.value)) {
                    throw new UnsupportedOperationException("doMaintenance: cannot operate on " + cur.value + " (DB) with " + this.modelVersion + " (software)");
                }
            } else {
                txn.rollbackTransaction();
                boolean bl = false;
                return bl;
            }
            log.debug((Object)"doMaintenance: possible to update - proceeding");
            boolean ret = false;
            if (!this.maintenanceSQL.isEmpty()) {
                for (String fname : this.maintenanceSQL) {
                    log.info((Object)("process file: " + fname));
                    List<String> statements = this.parseDDL(fname, this.schema, tag);
                    for (String sql : statements) {
                        log.info((Object)("execute statement:\n" + sql));
                        jdbc.execute(sql);
                    }
                }
                vdao.put(cur);
                ret = true;
            }
            txn.commitTransaction();
            long dt = System.currentTimeMillis() - t;
            log.debug((Object)("doMaintenance: " + this.modelName + " " + this.modelVersion + " " + dt + "ms"));
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException ex) {
            if (txn.isOpen()) {
                try {
                    txn.rollbackTransaction();
                }
                catch (Exception oops) {
                    log.error((Object)"failed to rollback transaction", (Throwable)oops);
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            log.debug((Object)"epic fail", (Throwable)ex);
            if (txn.isOpen()) {
                try {
                    txn.rollbackTransaction();
                }
                catch (Exception oops) {
                    log.error((Object)"failed to rollback transaction", (Throwable)oops);
                }
            }
            throw new RuntimeException("failed to init database", ex);
        }
        finally {
            if (txn.isOpen()) {
                log.error((Object)"BUG: open transaction in finally");
                try {
                    txn.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)"failed to rollback transaction in finally", (Throwable)ex);
                }
            }
        }
    }

    protected abstract URL findSQL(String var1);

    public List<String> parseDDL(String fname, String schema) throws IOException {
        return this.parseDDL(fname, schema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> parseDDL(String fname, String schema, String tag) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        URL url = this.findSQL(fname);
        log.info((Object)(this.getClass().getName() + " found: " + fname + " at " + url));
        if (url == null) {
            throw new RuntimeException("CONFIG: failed to find " + fname);
        }
        InputStreamReader isr = new InputStreamReader(url.openStream());
        try (LineNumberReader r = new LineNumberReader(isr);){
            StringBuilder sb = new StringBuilder();
            String line = r.readLine();
            boolean eos = false;
            while (line != null) {
                if ((line = line.trim()).startsWith("--")) {
                    line = "";
                }
                if (!line.isEmpty()) {
                    if (line.endsWith(";")) {
                        eos = true;
                        line = line.substring(0, line.length() - 1);
                    }
                    sb.append(line).append(" ");
                    if (eos) {
                        String st = sb.toString();
                        st = st.replaceAll("<schema>", schema);
                        if (tag != null) {
                            st = st.replace("<tag>", tag);
                        }
                        log.debug((Object)("statement: " + st));
                        ret.add(st);
                        sb = new StringBuilder();
                        eos = false;
                    }
                }
                line = r.readLine();
            }
        }
        return ret;
    }

    private boolean tableInDatabase() {
        String tableName = ModelVersion.class.getSimpleName();
        Connection con = null;
        JdbcTemplate jdbc = new JdbcTemplate(this.dataSource);
        try {
            con = jdbc.getDataSource().getConnection();
            DatabaseMetaData dm = con.getMetaData();
            String db = this.database == null ? null : this.database.toLowerCase();
            String sm = this.schema == null ? null : this.schema.toLowerCase();
            ResultSet rs = dm.getTables(db, sm, tableName.toLowerCase(), null);
            if (rs != null && !rs.next()) {
                log.debug((Object)("table does not exist: " + tableName));
                boolean bl = false;
                return bl;
            }
            log.debug((Object)("table exists: " + tableName));
        }
        catch (SQLException oops) {
            throw new RuntimeException("failed to determine if table exists: " + tableName, oops);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException ignore) {
                    log.debug((Object)"failed to close database metadata query result", (Throwable)ignore);
                }
            }
        }
        return true;
    }
}

