/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.db.version;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.db.version.KeyValue;
import ca.nrc.cadc.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public class KeyValueDAO {
    private static final Logger log = Logger.getLogger(KeyValueDAO.class);
    protected String[] columnNames;
    private final String database;
    private final String schema;
    private final String table;
    private final String tableName;
    private final DataSource dataSource;
    private final JdbcTemplate jdbc;
    private final ResultSetExtractor<KeyValue> extractor;
    private final Calendar utcCalendar = Calendar.getInstance(DateUtil.UTC);

    public KeyValueDAO(DataSource dataSource, String database, String schema) {
        this(dataSource, database, schema, KeyValue.class);
    }

    public KeyValueDAO(DataSource dataSource, String database, String schema, Class tupleType) {
        this.dataSource = dataSource;
        this.database = database;
        this.schema = schema;
        this.table = tupleType.getSimpleName();
        this.jdbc = new JdbcTemplate(dataSource);
        StringBuilder tn = new StringBuilder();
        if (database != null) {
            tn.append(database).append(".");
        }
        if (schema != null) {
            tn.append(schema).append(".");
        }
        tn.append(this.table);
        this.tableName = tn.toString();
        this.extractor = new KeyValueExtractor();
        this.columnNames = new String[]{"value", "lastModified", "name"};
    }

    public KeyValue lock(String name) {
        SelectStatementCreator sel = new SelectStatementCreator();
        sel.setValue(name, true);
        try {
            KeyValue ret = (KeyValue)this.jdbc.query((PreparedStatementCreator)sel, this.extractor);
            return ret;
        }
        catch (BadSqlGrammarException ex) {
            log.error((Object)("error locking: " + name), (Throwable)ex);
            return null;
        }
    }

    public KeyValue get(String name) {
        SelectStatementCreator sel = new SelectStatementCreator();
        sel.setValue(name, false);
        return (KeyValue)this.jdbc.query((PreparedStatementCreator)sel, this.extractor);
    }

    public void put(KeyValue kv) {
        boolean update = true;
        if (kv.lastModified == null) {
            update = false;
        }
        kv.lastModified = new Date();
        PutStatementCreator put = new PutStatementCreator(update);
        put.setValue(kv);
        this.jdbc.update((PreparedStatementCreator)put);
    }

    public void delete(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name arg cannot be null");
        }
        String sql = "DELETE FROM " + this.tableName + " WHERE " + this.columnNames[2] + " = ?";
        Object[] arg = new Object[]{name};
        this.jdbc.update(sql, arg);
    }

    public List<KeyValue> list() {
        SelectStatementCreator sel = new SelectStatementCreator();
        return this.jdbc.query((PreparedStatementCreator)sel, (RowMapper)new KeyValueRowMapper());
    }

    private static Date getDate(ResultSet rs, int col, Calendar cal) throws SQLException {
        Timestamp o = rs.getTimestamp(col, cal);
        return DateUtil.toDate(o);
    }

    private class KeyValueRowMapper
    implements RowMapper<KeyValue> {
        Calendar utc = Calendar.getInstance(DateUtil.UTC);

        private KeyValueRowMapper() {
        }

        public KeyValue mapRow(ResultSet rs, int i) throws SQLException {
            KeyValue keyValue = new KeyValue(rs.getString(3));
            keyValue.value = rs.getString(1);
            keyValue.lastModified = KeyValueDAO.getDate(rs, 2, KeyValueDAO.this.utcCalendar);
            return keyValue;
        }
    }

    private class KeyValueExtractor
    implements ResultSetExtractor<KeyValue> {
        private KeyValueExtractor() {
        }

        public KeyValue extractData(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return null;
            }
            KeyValueRowMapper m = new KeyValueRowMapper();
            return m.mapRow(rs, 1);
        }
    }

    private class PutStatementCreator
    implements PreparedStatementCreator {
        private final boolean update;
        private KeyValue state;

        PutStatementCreator(boolean update) {
            this.update = update;
        }

        public void setValue(KeyValue state) {
            this.state = state;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            StringBuilder sb = new StringBuilder();
            if (this.update) {
                sb.append("UPDATE ").append(KeyValueDAO.this.tableName).append(" SET ");
                sb.append(KeyValueDAO.this.columnNames[0]).append(" = ?, ");
                sb.append(KeyValueDAO.this.columnNames[1]).append(" = ?");
                sb.append(" WHERE ").append(KeyValueDAO.this.columnNames[2]).append(" = ?");
            } else {
                sb.append("INSERT INTO ").append(KeyValueDAO.this.tableName).append("(");
                sb.append(KeyValueDAO.this.columnNames[0]).append(",");
                sb.append(KeyValueDAO.this.columnNames[1]).append(",");
                sb.append(KeyValueDAO.this.columnNames[2]).append(")");
                sb.append(" values(?, ?, ?)");
            }
            String sql = sb.toString();
            PreparedStatement prep = conn.prepareStatement(sql);
            log.debug((Object)sql);
            this.loadValues(prep);
            return prep;
        }

        private void loadValues(PreparedStatement ps) throws SQLException {
            StringBuilder sb = new StringBuilder("values: ");
            int col = 1;
            ps.setString(col++, this.state.value);
            sb.append(this.state.value).append(",");
            ps.setTimestamp(col++, new Timestamp(this.state.lastModified.getTime()), KeyValueDAO.this.utcCalendar);
            sb.append(this.state.lastModified).append(",");
            ps.setString(col++, this.state.getName());
            sb.append(this.state.getName()).append(",");
            log.debug((Object)sb.toString());
        }
    }

    private class SelectStatementCreator
    implements PreparedStatementCreator {
        private boolean forUpdate = false;
        private String name;

        public void setValue(String name, boolean forUpdate) {
            this.name = name;
            this.forUpdate = forUpdate;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            sb.append(KeyValueDAO.this.columnNames[0]).append(",");
            sb.append(KeyValueDAO.this.columnNames[1]).append(",");
            sb.append(KeyValueDAO.this.columnNames[2]);
            sb.append(" FROM ").append(KeyValueDAO.this.tableName);
            if (StringUtil.hasText(this.name)) {
                sb.append(" WHERE ").append(KeyValueDAO.this.columnNames[2]).append(" = ?");
            }
            if (this.forUpdate) {
                sb.append(" FOR UPDATE");
            }
            String sql = sb.toString();
            PreparedStatement prep = conn.prepareStatement(sql);
            log.debug((Object)sql);
            if (StringUtil.hasText(this.name)) {
                this.loadValues(prep);
            }
            return prep;
        }

        private void loadValues(PreparedStatement ps) throws SQLException {
            ps.setString(1, this.name);
        }
    }
}

