/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.BulkDataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BulkDataInputStream
extends DataInputStream
implements BulkDataInput {
    protected boolean eos = false;

    public BulkDataInputStream(InputStream istream) {
        super(istream);
    }

    @Override
    public int readChar(char[] buf) throws IOException, EOFException {
        return this.readChar(buf, 0, buf.length);
    }

    @Override
    public int readChar(char[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readChar();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readByte(byte[] buf) throws IOException, EOFException {
        return this.readByte(buf, 0, buf.length);
    }

    @Override
    public int readByte(byte[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readByte();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readUnsignedByte(short[] buf) throws IOException, EOFException {
        return this.readUnsignedByte(buf, 0, buf.length);
    }

    @Override
    public int readUnsignedByte(short[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = (short)this.readUnsignedByte();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readShort(short[] buf) throws IOException, EOFException {
        return this.readShort(buf, 0, buf.length);
    }

    @Override
    public int readShort(short[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (i < len && !this.eos) {
            try {
                buf[i + off] = this.readShort();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readUnsignedShort(int[] buf) throws IOException, EOFException {
        return this.readUnsignedShort(buf, 0, buf.length);
    }

    @Override
    public int readUnsignedShort(int[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readUnsignedShort();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readInt(int[] buf) throws IOException, EOFException {
        return this.readInt(buf, 0, buf.length);
    }

    @Override
    public int readInt(int[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readInt();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readLong(long[] buf) throws IOException, EOFException {
        return this.readLong(buf, 0, buf.length);
    }

    @Override
    public int readLong(long[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readLong();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readFloat(float[] buf) throws IOException, EOFException {
        return this.readFloat(buf, 0, buf.length);
    }

    @Override
    public int readFloat(float[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readFloat();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }

    @Override
    public int readDouble(double[] buf) throws IOException, EOFException {
        return this.readDouble(buf, 0, buf.length);
    }

    @Override
    public int readDouble(double[] buf, int off, int len) throws IOException, EOFException {
        if (this.eos) {
            throw new EOFException();
        }
        int i = 0;
        while (!this.eos && i < len) {
            try {
                buf[i + off] = this.readDouble();
                ++i;
            }
            catch (EOFException e) {
                this.eos = true;
            }
        }
        return i;
    }
}

