/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.BulkDataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BulkDataOutputStream
extends DataOutputStream
implements BulkDataOutput {
    protected boolean eos = false;

    public BulkDataOutputStream(OutputStream ostream) {
        super(ostream);
    }

    @Override
    public void writeChar(char[] buf) throws IOException {
        this.writeChar(buf, 0, buf.length);
    }

    @Override
    public void writeChar(char[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeChar(buf[i + off]);
        }
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.write(b);
    }

    @Override
    public void writeByte(byte[] buf) throws IOException {
        this.writeByte(buf, 0, buf.length);
    }

    @Override
    public void writeByte(byte[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeByte(buf[i + off]);
        }
    }

    public void writeUnsignedByte(short i) throws IOException {
        this.writeByte(i + -128);
    }

    @Override
    public void writeUnsignedByte(short[] buf) throws IOException {
        this.writeUnsignedByte(buf, 0, buf.length);
    }

    @Override
    public void writeUnsignedByte(short[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeUnsignedByte(buf[i + off]);
        }
    }

    @Override
    public void writeShort(short[] buf) throws IOException {
        this.writeShort(buf, 0, buf.length);
    }

    @Override
    public void writeShort(short[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.writeShort(buf[i + off]);
        }
    }

    public void writeUnsignedShort(int i) throws IOException {
        this.writeShort(i + Short.MIN_VALUE);
    }

    @Override
    public void writeUnsignedShort(int[] buf) throws IOException {
        this.writeUnsignedShort(buf, 0, buf.length);
    }

    @Override
    public void writeUnsignedShort(int[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeUnsignedShort(buf[i + off]);
        }
    }

    @Override
    public void writeInt(int[] buf) throws IOException {
        this.writeInt(buf, 0, buf.length);
    }

    @Override
    public void writeInt(int[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeInt(buf[i + off]);
        }
    }

    @Override
    public void writeLong(long[] buf) throws IOException {
        this.writeLong(buf, 0, buf.length);
    }

    @Override
    public void writeLong(long[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeLong(buf[i + off]);
        }
    }

    @Override
    public void writeFloat(float[] buf) throws IOException {
        this.writeFloat(buf, 0, buf.length);
    }

    @Override
    public void writeFloat(float[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeFloat(buf[i + off]);
        }
    }

    @Override
    public void writeDouble(double[] buf) throws IOException {
        this.writeDouble(buf, 0, buf.length);
    }

    @Override
    public void writeDouble(double[] buf, int off, int len) throws IOException {
        for (int i = 0; i < off + len; ++i) {
            this.writeDouble(buf[i + off]);
        }
    }
}

