/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.ByteCounter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class ByteCountWriter
extends FilterWriter
implements ByteCounter {
    private Writer writer;
    private long byteCount = 0L;

    public ByteCountWriter(Writer writer) {
        super(writer);
    }

    @Override
    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.byteCount += (long)len;
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        ++this.byteCount;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.byteCount += (long)len;
    }
}

