/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.ReadException;
import ca.nrc.cadc.io.WriteException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class MultiBufferIO {
    private static final Logger log = Logger.getLogger(MultiBufferIO.class);
    private static final String READ_FAIL = "read from input stream failed";
    private static final String WRITE_FAIL = "write to output stream failed";
    private final int numBuffers;
    private final int bufferSize;
    private final BlockingQueue<Item> rq = new LinkedBlockingQueue<Item>();
    private final BlockingQueue<Item> wq = new LinkedBlockingQueue<Item>();

    public MultiBufferIO() {
        this(3, 65536);
    }

    public MultiBufferIO(int numBuffers, int bufferSize) {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("invalid numBuffers: " + numBuffers + " (minimum: 1)");
        }
        if (bufferSize < 8192) {
            throw new IllegalArgumentException("invalid bufferSize: " + bufferSize + " (minimum: 8192)");
        }
        this.numBuffers = numBuffers;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream input, OutputStream output) throws InterruptedException, ReadException, WriteException {
        for (int i = 0; i < this.numBuffers; ++i) {
            this.rq.put(new Item(this.bufferSize));
        }
        Worker w = new Worker(output);
        Thread writer = new Thread((Runnable)w, MultiBufferIO.class.getSimpleName() + "-writer");
        try {
            writer.start();
            Exception readFail = this.doit(input, w);
            log.debug((Object)("reader completed: " + readFail));
            if (readFail != null) {
                writer.interrupt();
            }
            writer.join();
            log.debug((Object)("writer completed: " + w.fail));
            if (readFail != null) {
                throw new ReadException(READ_FAIL, readFail);
            }
            if (w.fail != null) {
                throw new WriteException(WRITE_FAIL, w.fail);
            }
        }
        finally {
            if (writer.isAlive()) {
                try {
                    log.error((Object)("BUG: " + writer.getName() + " still alive in finally - interrupting..."));
                    writer.interrupt();
                    log.error((Object)("BUG: " + writer.getName() + " interrupted in finally - waiting..."));
                    writer.join();
                    log.error((Object)("BUG: " + writer.getName() + " still alive in finally - finished"));
                }
                catch (Exception ex) {
                    log.error((Object)("OOPS: failed to kill " + writer.getName()), (Throwable)ex);
                }
            }
        }
    }

    private Exception doit(InputStream istream, Worker w) {
        Object ret = null;
        try {
            while (w.fail == null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Item buf = this.rq.take();
                if (buf.num == -1) {
                    return null;
                }
                buf.num = istream.read(buf.buffer);
                this.wq.put(buf);
                if (buf.num != -1) continue;
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            Item term = new Item(0);
            term.num = -1;
            try {
                this.wq.put(term);
            }
            catch (InterruptedException oops) {
                log.debug((Object)"interrupted while putting terminator", (Throwable)oops);
            }
            return ex;
        }
    }

    private class Worker
    implements Runnable {
        private OutputStream ostream;
        Exception fail;

        public Worker(OutputStream ostream) {
            this.ostream = ostream;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Item buf = (Item)MultiBufferIO.this.wq.take();
                    if (buf.num == -1) {
                        return;
                    }
                    this.ostream.write(buf.buffer, 0, buf.num);
                    MultiBufferIO.this.rq.put(buf);
                }
            }
            catch (Exception ex) {
                this.fail = ex;
                Item term = new Item(0);
                term.num = -1;
                try {
                    MultiBufferIO.this.rq.put(term);
                }
                catch (InterruptedException oops) {
                    log.debug((Object)"interrupted while putting terminator", (Throwable)oops);
                }
                return;
            }
        }
    }

    private class Item {
        final byte[] buffer;
        int num = 0;

        Item(int sz) {
            this.buffer = new byte[sz];
        }
    }
}

