/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.NoisyStream;
import ca.nrc.cadc.io.NoisyStreamListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class NoisyBufferedOutputStream
extends BufferedOutputStream
implements NoisyStream {
    private long bytes = 0L;
    private int blocks = 0;
    private int reportSize = 4096;
    private List<NoisyStreamListener> listeners = new ArrayList<NoisyStreamListener>();

    public NoisyBufferedOutputStream(OutputStream out) {
        super(out);
    }

    public NoisyBufferedOutputStream(OutputStream out, int bufSize) {
        super(out, bufSize);
    }

    @Override
    public long getByteCount() {
        return (long)(this.reportSize * this.blocks) + this.bytes;
    }

    @Override
    public void setReportSize(int numbytes) {
        this.bytes = this.getByteCount();
        this.blocks = 0;
        this.reportSize = numbytes;
        this.doit();
    }

    @Override
    public void addListener(NoisyStreamListener listener) {
        this.listeners.add(listener);
        listener.update(this);
    }

    @Override
    public void removeListener(NoisyStreamListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeListeners() {
        this.listeners.clear();
    }

    protected void notifyListeners() {
        for (NoisyStreamListener n : this.listeners) {
            n.update(this);
        }
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.bytes;
        this.doit();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.bytes += (long)Math.min(len, b.length - off);
        this.doit();
    }

    @Override
    public void close() throws IOException {
        this.notifyListeners();
        super.close();
    }

    private void doit() {
        boolean changed = false;
        while (this.bytes >= (long)this.reportSize) {
            long b = this.bytes / (long)this.reportSize;
            this.blocks += (int)b;
            this.bytes -= b * (long)this.reportSize;
            changed = true;
        }
        if (changed) {
            this.notifyListeners();
        }
    }
}

