/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.log;

import ca.nrc.cadc.log.WebServiceLogInfo;
import ca.nrc.cadc.net.NetUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ServletLogInfo
extends WebServiceLogInfo {
    private static Logger log = Logger.getLogger(ServletLogInfo.class);

    public ServletLogInfo(HttpServletRequest request) {
        String query;
        String pathInfo;
        this.method = request.getMethod().toUpperCase();
        this.ip = NetUtil.getClientIP(request);
        String contextPath = request.getContextPath();
        this.serviceName = this.parseServiceName(contextPath);
        String servletPath = request.getServletPath();
        if (servletPath == null) {
            servletPath = "";
        }
        if ((pathInfo = request.getPathInfo()) == null) {
            pathInfo = "";
        }
        if ((query = request.getQueryString()) == null) {
            query = "";
        } else {
            try {
                query = "?" + URLDecoder.decode(query, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)String.format("Error decoding %s because %s", query, e.getMessage()));
            }
        }
        this.path = contextPath + servletPath + pathInfo + query;
        if (query.length() > 0) {
            String[] parameters;
            for (String key : parameters = query.substring(1).split("&")) {
                String value;
                if (!key.toLowerCase().startsWith("runid=") || (value = key.substring(6)).length() <= 0) continue;
                this.runID = value;
            }
        }
    }
}

