/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.log;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public abstract class WebServiceLogInfo {
    private static final Logger log = Logger.getLogger(WebServiceLogInfo.class);
    private boolean userSuccess = true;
    protected String serviceName;
    protected Long bytes;
    protected String ip;
    protected String jobID;
    protected String message;
    protected String method;
    protected String authMethod;
    protected String path;
    protected String proxyUser;
    protected String runID;
    protected Boolean success;
    protected Long duration;
    protected Long overhead;
    protected URI resource;
    protected String grant;
    public String user;

    protected WebServiceLogInfo() {
    }

    public String start() {
        return "{" + this.getPreamble() + "\"phase\":\"start\"," + this.doit() + "}";
    }

    public String end() {
        this.success = this.userSuccess;
        return "{" + this.getPreamble() + "\"phase\":\"end\"," + this.doit() + "}";
    }

    String doit() {
        StringBuilder sb = new StringBuilder();
        this.populate(sb, this.getClass());
        return sb.toString();
    }

    private String getTimestamp() {
        DateFormat format = DateUtil.getDateFormat("yyyy-MM-dd HH:mm:ss.SSS", DateUtil.UTC);
        Date date = new Date(System.currentTimeMillis());
        return "\"@timestamp\":\"" + format.format(date) + "\"";
    }

    private String getServiceName() {
        return "\"service\":{\"name\":\"" + this.serviceName + "\"}";
    }

    private String getThreadName() {
        return "\"thread\":{\"name\":\"" + Thread.currentThread().getName() + "\"}";
    }

    private String getLoglevel() {
        return "\"log\":{\"level\":\"info\"}";
    }

    private String getPreamble() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp()).append(",");
        sb.append(this.getServiceName()).append(",");
        sb.append(this.getThreadName()).append(",");
        sb.append(this.getLoglevel()).append(",");
        return sb.toString();
    }

    private void populateList(StringBuilder sb, List<?> o) {
        sb.append("[");
        if (!o.isEmpty()) {
            boolean isFirstElement = true;
            for (Object element : o) {
                String val = WebServiceLogInfo.sanitize(element);
                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    sb.append(",");
                }
                if (element instanceof String || element instanceof UUID) {
                    sb.append("\"").append(val).append("\"");
                    continue;
                }
                sb.append(val);
            }
        }
        sb.append("]");
    }

    private void populate(StringBuilder sb, Class<?> c) {
        for (Field f : c.getDeclaredFields()) {
            log.debug((Object)("found field: " + f.getName()));
            int m = f.getModifiers();
            boolean inc = true;
            inc = inc && !Modifier.isStatic(m);
            inc = inc && !Modifier.isPrivate(m);
            boolean bl = inc = inc && !Modifier.isTransient(m);
            if (!inc) continue;
            try {
                Object o = f.get(this);
                log.debug((Object)(f.getName() + " = " + o));
                if (o == null || f.getName().equals("serviceName")) continue;
                String val = WebServiceLogInfo.sanitize(o);
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append("\"").append(f.getName()).append("\"");
                sb.append(":");
                if (o instanceof URI) {
                    o = ((URI)o).toASCIIString();
                }
                if (o instanceof List) {
                    this.populateList(sb, (List)o);
                    continue;
                }
                if (o instanceof String) {
                    sb.append("\"").append(val).append("\"");
                    continue;
                }
                sb.append(val);
            }
            catch (IllegalAccessException ex) {
                log.error((Object)("BUG: failed to get value for " + f.getName()), (Throwable)ex);
            }
        }
        Class<?> sc = c.getSuperclass();
        if (WebServiceLogInfo.class.isAssignableFrom(sc)) {
            this.populate(sb, sc);
        }
    }

    static String sanitize(Object o) {
        String ret = o.toString();
        ret = ret.replaceAll("\"", "'");
        ret = ret.replaceAll("\\s+", " ");
        return ret;
    }

    public void setSuccess(boolean success) {
        this.userSuccess = success;
    }

    public void setSubject(Subject subject) {
        this.user = this.getUser(subject);
        AuthMethod amethod = AuthenticationUtil.getAuthMethod(subject);
        this.authMethod = amethod != null ? amethod.getValue() : AuthMethod.ANON.getValue();
    }

    public void setElapsedTime(Long elapsedTime) {
        this.duration = elapsedTime;
    }

    public void setOverhead(Long overhead) {
        this.overhead = overhead;
    }

    public void setBytes(Long bytes) {
        this.bytes = bytes;
    }

    public void setMessage(String message) {
        if (StringUtil.hasText(message)) {
            this.message = message.trim();
        }
    }

    public void setResource(URI resource) {
        this.resource = resource;
    }

    public void setGrant(String grant) {
        this.grant = grant;
    }

    public void setJobID(String jobID) {
        if (StringUtil.hasText(jobID)) {
            this.jobID = jobID.trim();
        }
    }

    protected String getUser(Subject subject) {
        try {
            if (subject != null) {
                Set<HttpPrincipal> httpPrincipals = subject.getPrincipals(HttpPrincipal.class);
                if (!httpPrincipals.isEmpty()) {
                    HttpPrincipal principal = httpPrincipals.iterator().next();
                    this.proxyUser = principal.getProxyUser();
                    return principal.getName();
                }
                Set<X500Principal> x500Principals = subject.getPrincipals(X500Principal.class);
                if (!x500Principals.isEmpty()) {
                    X500Principal principal = x500Principals.iterator().next();
                    return principal.getName();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRunID(String runID) {
        this.runID = runID;
    }

    protected String parseServiceName(String path) {
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return path.split("/")[0];
        }
        return "";
    }
}

