/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class AuthChallenge {
    private static final Logger log = Logger.getLogger(AuthChallenge.class);
    private final String name;
    private Map<String, String> params = new TreeMap<String, String>();

    public AuthChallenge(String challenge) {
        String s = challenge.replace(",", " ");
        String[] parts = s.split("[ \t]");
        this.name = parts[0];
        if (parts.length == 1) {
            return;
        }
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i].trim();
            if (p.isEmpty()) continue;
            String[] kv = parts[i].split("=");
            if (kv.length == 1) {
                this.params.put(kv[0], null);
                continue;
            }
            String v = kv[1].replace("\"", "");
            this.params.put(kv[0], v);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParamValue(String paramName) {
        return this.params.get(paramName);
    }

    public String toString() {
        return "Challenge[" + this.name + "," + this.params.size() + "]";
    }

    public String getHeaderValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" ");
        boolean needComma = false;
        for (Map.Entry<String, String> me : this.params.entrySet()) {
            if (needComma) {
                sb.append(",");
            }
            sb.append(me.getKey() + " =\"").append(me.getValue()).append("\"");
            needComma = true;
        }
        return sb.toString();
    }
}

