/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import org.apache.log4j.Logger;

public class ContentType {
    private static final Logger log = Logger.getLogger(ContentType.class);
    private String value;
    private String baseType;

    public ContentType(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        this.value = this.toCanonicalForm(value);
        if (this.baseType == null) {
            throw new IllegalArgumentException("null base type");
        }
    }

    public String toString() {
        return "ContentType[" + this.value + "]";
    }

    public String getValue() {
        return this.value;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ContentType) {
            ContentType rhs = (ContentType)obj;
            return this.value.equalsIgnoreCase(rhs.value);
        }
        return false;
    }

    private String toCanonicalForm(String s) {
        s = s.trim();
        String[] parts = s.split(";");
        StringBuilder sb = new StringBuilder();
        sb.append(parts[0]);
        this.baseType = parts[0];
        for (int i = 1; i < parts.length; ++i) {
            sb.append(";").append(parts[i].trim());
        }
        return sb.toString();
    }
}

