/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.util.StringUtil;
import java.net.URI;
import java.util.Base64;
import org.apache.log4j.Logger;

public class DigestUtil {
    private static Logger log = Logger.getLogger(DigestUtil.class);

    public static String toDigest(URI checksumURI) {
        String algorithm = checksumURI.getScheme();
        String checksum = checksumURI.getSchemeSpecificPart();
        String base64Checksum = DigestUtil.base64EncodeHex(checksum);
        return algorithm + "=" + base64Checksum;
    }

    public static URI getURI(String digest) {
        Algorithm algorithm;
        if (!StringUtil.hasLength(digest)) {
            return null;
        }
        int index = digest.indexOf(61);
        if (index == -1) {
            throw new IllegalArgumentException(String.format("Expected digest format <algorithm>=<checksum value> found %s", digest));
        }
        String scheme = digest.substring(0, index).trim();
        String base64Checksum = digest.substring(index + 1).trim();
        if (scheme.length() == 0) {
            throw new IllegalArgumentException(String.format("Unable to parse algorithm, expected format <algorithm>=<checksum value> found %s", digest));
        }
        if (base64Checksum.length() == 0) {
            throw new IllegalArgumentException(String.format("Unable to parse checksum, expected format <algorithm>=<checksum value> found %s", digest));
        }
        try {
            algorithm = Algorithm.fromString(scheme);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported algorithm %s", scheme));
        }
        String checksum = DigestUtil.base64DecodeToHex(base64Checksum);
        if (algorithm == Algorithm.MD5 && checksum.length() != 32) {
            throw new IllegalArgumentException(String.format("Invalid MD5 checksum, expected 32 chars, found %s in %s", checksum.length(), checksum));
        }
        if (algorithm == Algorithm.SHA1 && checksum.length() != 40) {
            throw new IllegalArgumentException(String.format("Invalid SHA-1 checksum, expected 40 chars, found %s in %s", checksum.length(), checksum));
        }
        if (algorithm == Algorithm.SHA256 && checksum.length() != 64) {
            throw new IllegalArgumentException(String.format("Invalid SHA-256 checksum, expected 64 chars, found %s in %s", checksum.length(), checksum));
        }
        if (algorithm == Algorithm.SHA384 && checksum.length() != 96) {
            throw new IllegalArgumentException(String.format("Invalid SHA-384 checksum, expected 96 chars, found %s in %s", checksum.length(), checksum));
        }
        if (algorithm == Algorithm.SHA512 && checksum.length() != 128) {
            throw new IllegalArgumentException(String.format("Invalid SHA-512 checksum, expected 128 chars, found %s in %s", checksum.length(), checksum));
        }
        return URI.create(algorithm.value + ":" + checksum);
    }

    static String base64EncodeHex(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        byte[] bytes = HexUtil.toBytes(value);
        return Base64.getEncoder().encodeToString(bytes);
    }

    static String base64DecodeToHex(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        byte[] decoded = Base64.getDecoder().decode(value);
        return HexUtil.toHex(decoded);
    }

    public static enum Algorithm {
        MD5("md5"),
        SHA1("sha-1"),
        SHA256("sha-256"),
        SHA384("sha-384"),
        SHA512("sha-512");

        public final String value;

        private Algorithm(String value) {
            this.value = value;
        }

        public static Algorithm fromString(String value) {
            for (Algorithm algorithm : Algorithm.values()) {
                if (!algorithm.value.equalsIgnoreCase(value)) continue;
                return algorithm;
            }
            throw new IllegalArgumentException(String.format("Algorithm not found for value %s", value));
        }
    }
}

