/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.RangeNotSatisfiableException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpDelete
extends HttpTransfer {
    private static final Logger log = Logger.getLogger(HttpUpload.class);

    public HttpDelete(URL remoteURL, boolean followRedirects) {
        super(remoteURL, followRedirects);
    }

    public String toString() {
        return HttpDelete.class.getSimpleName() + "[" + this.remoteURL + "]";
    }

    @Override
    public void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        this.doActionWithRetryLoop();
    }

    @Override
    protected void doAction() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        log.debug((Object)("connect: " + this.remoteURL));
        HttpURLConnection conn = (HttpURLConnection)this.remoteURL.openConnection();
        super.setRequestOptions(conn);
        conn.setRequestMethod("DELETE");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(false);
        conn.setInstanceFollowRedirects(this.followRedirects);
        this.setRequestHeaders(conn);
        this.setRequestAuthHeaders(conn);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            this.initHTTPS(sslConn);
        }
        this.checkErrors(this.remoteURL, conn);
    }
}

