/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.IncorrectContentChecksumException;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.OverwriteChooser;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.RangeNotSatisfiableException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.FileMetadata;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpDownload
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpDownload.class);
    private static int NONE = 0;
    private static int GZIP = 1;
    private static int ZIP = 2;
    private boolean headOnly = false;
    private String logAction = "HTTP GET";
    private boolean decompress = false;
    private boolean overwrite = false;
    private File destDir = null;
    private File origFile;
    private File decompFile;
    private File removeFile;
    private int decompressor;
    private OutputStream destStream;
    private String serverFilename;
    private File destFile;
    private InputStreamWrapper wrapper;
    private long decompSize = -1L;
    private long size = -1L;
    private OverwriteChooser overwriteChooser;
    private static char SINGLE_QUOTE = "'".charAt(0);
    private static char DOUBLE_QUOTE = "\"".charAt(0);

    public HttpDownload(URL src, File dest) {
        this(null, src, dest);
    }

    @Deprecated
    public HttpDownload(URL src, OutputStream dest) {
        this(null, src, dest);
    }

    @Deprecated
    public HttpDownload(URL src, InputStreamWrapper dest) {
        this(null, src, dest);
    }

    public HttpDownload(String userAgent, URL url, File dest) {
        super(url, true);
        this.setUserAgent(userAgent);
        if (url == null) {
            throw new IllegalArgumentException("source URL cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("destination File cannot be null");
        }
        if (dest.exists() && dest.isDirectory()) {
            this.destDir = dest;
        } else {
            File parent = dest.getParentFile();
            if (parent == null) {
                throw new IllegalArgumentException("destination File cannot be relative");
            }
            this.destDir = parent;
            this.localFile = dest;
        }
    }

    @Deprecated
    public HttpDownload(String userAgent, URL url, OutputStream dest) {
        super(url, true);
        this.setUserAgent(userAgent);
        if (dest == null) {
            throw new IllegalArgumentException("destination stream cannot be null");
        }
        this.destStream = dest;
    }

    @Deprecated
    public HttpDownload(String userAgent, URL url, InputStreamWrapper dest) {
        super(url, true);
        this.setUserAgent(userAgent);
        if (dest == null) {
            throw new IllegalArgumentException("destination wrapper cannot be null");
        }
        this.wrapper = dest;
    }

    public String toString() {
        return "HttpDownload[" + this.remoteURL + "," + this.localFile + "]";
    }

    public void setHeadOnly(boolean headOnly) {
        this.headOnly = headOnly;
        if (headOnly) {
            this.logAction = "HTTP HEAD";
        }
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    public void setOverwriteChooser(OverwriteChooser overwriteChooser) {
        this.overwriteChooser = overwriteChooser;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public long getSize() {
        return this.size;
    }

    public String getFilename() {
        return this.serverFilename;
    }

    public File getFile() {
        return this.destFile;
    }

    @Override
    public void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void run() {
        try {
            this.doActionWithRetryLoop();
        }
        catch (Throwable t) {
            this.failure = t;
        }
        finally {
            this.responseStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        log.debug((Object)this.toString());
        if (!this.go) {
            return;
        }
        boolean throwTE = false;
        URL currentURL = this.remoteURL;
        try {
            this.thread = Thread.currentThread();
            this.fireEvent(1);
            boolean done = false;
            ArrayList<URL> visitedURLs = new ArrayList<URL>();
            while (!done) {
                done = true;
                this.doGet(currentURL);
                if (!this.followRedirects || this.redirectURL == null) continue;
                if (visitedURLs.contains(this.redirectURL)) {
                    throw new IllegalArgumentException("redirect back to a previously visited URL: " + this.redirectURL);
                }
                if (visitedURLs.size() > 6) {
                    throw new IllegalArgumentException("redirect exceeded hard-coded limit (6): " + this.redirectURL);
                }
                visitedURLs.add(currentURL);
                currentURL = this.redirectURL;
                this.redirectURL = null;
                done = false;
            }
            if (this.decompress && this.decompressor != NONE) {
                this.fireEvent(this.decompFile, 4);
                this.doDecompress();
            }
        }
        finally {
            HttpDownload done = this;
            synchronized (done) {
                if (this.thread != null) {
                    if (Thread.interrupted()) {
                        this.go = false;
                    }
                    this.thread = null;
                }
            }
            if (this.failure == null && this.removeFile != null) {
                log.debug((Object)("removing: " + this.removeFile));
                this.fireEvent(this.removeFile, 8);
                this.removeFile.delete();
            }
            if (!this.go) {
                log.debug((Object)"cancelled");
                this.fireEvent(6);
            } else if (this.failure != null) {
                log.debug((Object)("failed: " + this.failure));
                this.fireEvent(this.failure);
            } else if (!throwTE) {
                log.debug((Object)"completed");
                FileMetadata meta = new FileMetadata();
                meta.setContentType(this.getContentType());
                meta.setContentEncoding(this.getContentEncoding());
                meta.setContentLength(this.getContentLength());
                meta.setMd5Sum(this.getContentMD5());
                meta.setLastModified(this.getLastModified());
                this.fireEvent(this.destFile, 5, meta);
            }
        }
    }

    protected boolean askOverwrite(File f, Long length, Date lastModified) {
        Long lastMod = null;
        if (lastModified != null) {
            lastMod = lastModified.getTime();
        }
        return this.overwrite || this.overwriteChooser != null && this.overwriteChooser.overwriteFile(f.getAbsolutePath(), f.length(), f.lastModified(), length, lastMod);
    }

    private boolean doCheckDestination() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean doDownload = true;
        if (this.origFile.exists()) {
            log.debug((Object)(this.origFile + " exists"));
            if (this.askOverwrite(this.origFile, this.getContentLength(), this.getLastModified())) {
                log.debug((Object)("overwrite: YES -- " + this.origFile));
                this.origFile.delete();
                if (this.decompFile != null && this.decompFile.exists()) {
                    this.decompFile.delete();
                }
                this.destFile = this.decompress && this.decompressor != NONE ? this.decompFile : this.origFile;
            } else {
                log.debug((Object)("overwrite: NO -- " + this.origFile));
                if (this.decompress && this.decompressor != NONE) {
                    this.decompFile.delete();
                    doDownload = false;
                    this.destFile = this.decompFile;
                    this.removeFile = this.origFile;
                } else {
                    doDownload = false;
                }
            }
        } else if (this.decompFile != null && this.decompFile.exists()) {
            log.debug((Object)(this.decompFile + " exists"));
            if (this.askOverwrite(this.decompFile, this.decompSize, this.getLastModified())) {
                log.debug((Object)("overwrite: YES -- " + this.decompFile));
                this.removeFile = this.decompFile;
                this.destFile = this.decompress && this.decompressor != NONE ? this.decompFile : this.origFile;
            } else {
                log.debug((Object)("overwrite: NO -- " + this.decompFile));
                this.destFile = this.decompFile;
                this.removeFile = null;
                doDownload = false;
            }
        } else {
            this.destFile = this.decompress && this.decompressor != NONE && this.decompFile != null ? this.decompFile : this.origFile;
        }
        log.debug((Object)("destination file: " + this.destFile));
        this.localFile = this.destFile;
        return doDownload;
    }

    private void processHeader(HttpURLConnection conn) throws IOException, InterruptedException {
        String ucl = conn.getHeaderField("X-Uncompressed-Length");
        if (ucl != null) {
            try {
                this.decompSize = Long.parseLong(ucl);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.serverFilename = this.getServerFilename(conn);
        if (this.destStream == null && this.wrapper == null) {
            String origFilename = null;
            if (this.localFile != this.destDir) {
                this.origFile = this.localFile;
            }
            if (this.origFile == null) {
                this.origFile = new File(this.destDir, this.serverFilename);
            }
            origFilename = this.origFile.getName();
            if ("gzip".equals(this.getContentEncoding()) || origFilename.endsWith(".gz")) {
                if (origFilename.endsWith(".gz")) {
                    this.decompFile = new File(this.destDir, origFilename.substring(0, origFilename.length() - 3));
                } else {
                    this.decompFile = this.origFile;
                    this.origFile = new File(this.destDir, origFilename + ".gz");
                }
                this.decompressor = GZIP;
            } else if ("zip".equals(this.getContentEncoding()) || origFilename.endsWith(".zip")) {
                if (origFilename.endsWith(".zip")) {
                    this.decompFile = new File(this.destDir, origFilename.substring(0, origFilename.length() - 4));
                } else {
                    this.decompFile = this.origFile;
                    this.origFile = new File(this.destDir, origFilename + ".zip");
                }
                this.decompressor = ZIP;
            }
        }
        log.debug((Object)("   original file: " + this.origFile));
        log.debug((Object)("     decomp file: " + this.decompFile));
        log.debug((Object)("  content length: " + this.getContentLength()));
        log.debug((Object)("     content md5: " + this.getContentMD5()));
        log.debug((Object)("    content type: " + this.getContentType()));
        log.debug((Object)("content encoding: " + this.getContentEncoding()));
        log.debug((Object)("     decomp size: " + this.decompSize));
        log.debug((Object)("    decompressor: " + this.decompressor));
        log.debug((Object)("    lastModified: " + this.getLastModified()));
    }

    private String getServerFilename(HttpURLConnection conn) {
        String ret = null;
        String cdisp = conn.getHeaderField("Content-Disposition");
        log.debug((Object)("HTTP HEAD: Content-Disposition = " + cdisp));
        if (cdisp != null) {
            ret = HttpDownload.parseContentDisposition(cdisp);
        }
        if (ret == null) {
            String s = this.remoteURL.getPath();
            String query = this.remoteURL.getQuery();
            int i = s.lastIndexOf(47);
            if (i != -1 && i < s.length() - 1) {
                ret = s.substring(i + 1, s.length());
            }
            if (query != null) {
                ret = ret + "?" + query;
            }
        }
        if (ret == null) {
            ret = this.remoteURL.getHost();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doGet(URL url) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        InputStream istream = null;
        OutputStream ostream = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            super.setRequestOptions(conn);
            log.debug((Object)("HttpURLConnection type: " + conn.getClass().getName() + " for GET " + url));
            if (this.headOnly) {
                conn.setRequestMethod("HEAD");
            } else {
                conn.setRequestMethod("GET");
            }
            this.setRequestAuthHeaders(conn);
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                this.initHTTPS(sslConn);
            }
            conn.setInstanceFollowRedirects(this.followRedirects);
            conn.setRequestProperty("Accept", "*/*");
            this.setRequestHeaders(conn);
            this.requestStartTime = System.currentTimeMillis();
            this.checkErrors(url, conn);
            this.checkRedirects(url, conn);
            this.processHeader(conn);
            if (this.headOnly) return;
            if (!this.followRedirects && this.redirectURL != null) {
                return;
            }
            boolean doDownload = true;
            if (this.destStream == null && this.wrapper == null) {
                doDownload = this.doCheckDestination();
            }
            boolean bl = this.go = this.go && doDownload;
            if (!this.go) {
                return;
            }
            File tmp = this.origFile;
            this.size = this.getContentLength();
            String pkey = null;
            String pvalue = null;
            boolean append = false;
            long startingPos = 0L;
            if (this.destStream == null && this.wrapper == null) {
                this.origFile = new File(this.origFile.getAbsolutePath() + ".part");
                if (this.origFile.exists() && this.origFile.length() < this.getContentLength()) {
                    pkey = "Range";
                    pvalue = "bytes=" + this.origFile.length() + "-";
                }
            }
            if (pkey != null) {
                HttpURLConnection rconn = (HttpURLConnection)url.openConnection();
                super.setRequestOptions(rconn);
                log.debug((Object)("HttpURLConnection type: " + rconn.getClass().getName() + " for GET " + url));
                rconn.setRequestMethod("GET");
                this.setRequestAuthHeaders(rconn);
                if (rconn instanceof HttpsURLConnection) {
                    HttpsURLConnection sslConn = (HttpsURLConnection)rconn;
                    this.initHTTPS(sslConn);
                }
                rconn.setInstanceFollowRedirects(true);
                rconn.setRequestProperty("Accept", "*/*");
                this.setRequestHeaders(rconn);
                log.debug((Object)("trying: " + pkey + " = " + pvalue));
                rconn.setRequestProperty(pkey, pvalue);
                int rcode = rconn.getResponseCode();
                log.debug((Object)(this.logAction + " status: " + rcode + " for range request to " + url));
                if (rcode == 206) {
                    String cr = conn.getHeaderField("Content-Range");
                    log.debug((Object)("Content-Range = " + cr));
                    if (cr != null && (cr = cr.trim()).startsWith("bytes")) {
                        cr = cr.substring(6);
                        String[] parts = cr.split("-");
                        startingPos = Long.parseLong(parts[0]);
                        log.debug((Object)("found startingPos = " + startingPos));
                        String[] ss = cr.split("/");
                        this.size = Long.parseLong(ss[1]);
                        log.debug((Object)("found real size = " + this.size));
                        append = true;
                    }
                    if (append) {
                        try {
                            log.debug((Object)"can resume: closing first connection");
                            conn.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        conn = rconn;
                        this.checkErrors(url, conn);
                    } else {
                        try {
                            log.debug((Object)"cannot resume: closing second connection");
                            rconn.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.fireEvent(2);
            this.findEventID(conn);
            this.fireEvent(this.origFile, 3);
            istream = conn.getInputStream();
            if (!(istream instanceof BufferedInputStream)) {
                log.debug((Object)"using BufferedInputStream");
                istream = new BufferedInputStream(istream, this.bufferSize);
            }
            if (this.destStream != null) {
                log.debug((Object)"output: supplied OutputStream");
                ostream = this.destStream;
                log.debug((Object)"using BufferedOutputStream");
                ostream = new BufferedOutputStream(ostream, this.bufferSize);
            } else if (this.wrapper == null) {
                File parent = this.origFile.getParentFile();
                parent.mkdirs();
                if (!parent.exists()) {
                    throw new IOException("failed to create one or more parent dir(s):" + parent);
                }
                log.debug((Object)("output: " + this.origFile + " append: " + append));
                ostream = new FileOutputStream(this.origFile, append);
                log.debug((Object)"using BufferedOutputStream");
                ostream = new BufferedOutputStream(ostream, this.bufferSize);
            }
            if (this.wrapper != null) {
                this.wrapper.read(istream);
            } else if (this.userNio) {
                this.nioLoop(istream, ostream, 2 * this.bufferSize, startingPos);
            } else {
                String md5 = this.ioLoop(istream, ostream, 2 * this.bufferSize, startingPos);
                if (this.getContentMD5() != null && md5 != null && !md5.equals(this.getContentMD5())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("MD5 mismatch: ");
                    sb.append(this.getContentMD5()).append(" (header) != ").append(md5).append(" (bytes)");
                    if (url != null) {
                        sb.append(" url: ").append(url);
                    }
                    if (this.destFile == null) throw new IncorrectContentChecksumException(sb.toString());
                    sb.append(" destFile: ").append(this.destFile.getAbsolutePath());
                    throw new IncorrectContentChecksumException(sb.toString());
                }
            }
            if (ostream != null) {
                long writeStart = System.currentTimeMillis();
                ostream.flush();
                if (this.logIO) {
                    long flushTime = System.currentTimeMillis() - writeStart;
                    this.writeTime += flushTime;
                    log.debug((Object)("Time (ms) to flush: " + flushTime));
                }
            }
            log.debug((Object)"download completed");
            if (this.destStream != null) return;
            if (this.wrapper != null) return;
            log.debug((Object)("renaming " + this.origFile + " to " + tmp));
            this.origFile.renameTo(tmp);
            this.origFile = tmp;
            this.destFile = tmp;
            return;
        }
        finally {
            if (istream != null) {
                log.debug((Object)"closing InputStream");
                try {
                    istream.close();
                }
                catch (Exception sslConn) {}
            }
            if (ostream != null) {
                log.debug((Object)"closing OutputStream");
                try {
                    ostream.close();
                }
                catch (Exception sslConn) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecompress() throws IOException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        InputStream istream = null;
        OutputStream ostream = null;
        try {
            this.size = this.decompSize;
            int sz = this.bufferSize;
            if (this.decompressor == GZIP) {
                log.debug((Object)"input: GZIPInputStream(BufferedInputStream(FileInputStream)");
                istream = new GZIPInputStream((InputStream)new FileInputStream(this.origFile), sz);
            } else if (this.decompressor == ZIP) {
                log.debug((Object)"input: ZIPInputStream(BufferedInputStream(FileInputStream)");
                istream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.origFile)));
            }
            log.debug((Object)("output: " + this.decompFile));
            ostream = new BufferedOutputStream(new FileOutputStream(this.decompFile), sz);
            this.removeFile = this.origFile;
            if (this.userNio) {
                this.nioLoop(istream, ostream, sz, 0L);
            } else {
                this.ioLoop(istream, ostream, sz, 0L);
            }
            ostream.flush();
            this.destFile = this.decompFile;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception exception) {}
            }
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static boolean isFilenameDisposition(String cdisp) {
        if (cdisp == null) {
            return false;
        }
        return (cdisp = cdisp.toLowerCase()).startsWith("attachment") || cdisp.startsWith("inline");
    }

    public static String parseContentDisposition(String cdisp) {
        if (!HttpDownload.isFilenameDisposition(cdisp)) {
            return null;
        }
        String[] parts = cdisp.split(";");
        for (int p = 0; p < parts.length; ++p) {
            boolean re;
            String part = parts[p].trim();
            if (part.charAt(0) == '\"') {
                part = part.substring(1, part.length());
            }
            if (part.charAt(part.length() - 1) == '\"') {
                part = part.substring(0, part.length() - 1);
            }
            if (!part.startsWith("filename")) continue;
            int i = part.indexOf(61);
            String filename = part.substring(i + 1, part.length());
            char c1 = filename.charAt(0);
            char c2 = filename.charAt(filename.length() - 1);
            boolean rs = c1 == SINGLE_QUOTE || c1 == DOUBLE_QUOTE;
            boolean bl = re = c2 == SINGLE_QUOTE || c2 == DOUBLE_QUOTE;
            if (rs && re) {
                filename = filename.substring(1, filename.length() - 1);
            } else if (rs) {
                filename = filename.substring(1, filename.length());
            } else if (re) {
                filename = filename.substring(0, filename.length() - 1);
            }
            i = filename.lastIndexOf(47);
            if (i >= 0) {
                filename = filename.substring(i + 1);
            }
            if ((i = filename.lastIndexOf(92)) >= 0) {
                filename = filename.substring(i + 1);
            }
            return filename;
        }
        return null;
    }
}

