/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.RangeNotSatisfiableException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpGet
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpGet.class);
    private boolean headOnly = false;

    public HttpGet(URL url, boolean followRedirects) {
        super(url, followRedirects);
    }

    public HttpGet(URL url, OutputStream dest) {
        super(url, true);
        if (dest == null) {
            throw new IllegalArgumentException("destination File cannot be null");
        }
        this.responseDestination = dest;
    }

    public HttpGet(URL url, InputStreamWrapper dest) {
        super(url, true);
        if (dest == null) {
            throw new IllegalArgumentException("destination wrapper cannot be null");
        }
        this.responseStreamWrapper = dest;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.remoteURL + ", head=" + this.headOnly + "]";
    }

    public void setHeadOnly(boolean headOnly) {
        this.headOnly = headOnly;
    }

    @Override
    public void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        this.doActionWithRetryLoop();
    }

    @Override
    public void run() {
        if (this.headOnly) {
            if (this.failure == null) {
                try {
                    if (this.responseStream == null) {
                        this.prepare();
                    }
                }
                catch (Throwable t) {
                    this.failure = t;
                }
            }
        } else {
            super.run();
        }
    }

    @Override
    protected void doAction() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        log.debug((Object)this.toString());
        if (!this.go) {
            return;
        }
        URL currentURL = this.remoteURL;
        this.fireEvent(1);
        boolean done = false;
        ArrayList<URL> visitedURLs = new ArrayList<URL>();
        while (!done) {
            done = true;
            this.doGet(currentURL);
            if (!this.followRedirects || this.redirectURL == null) continue;
            if (visitedURLs.contains(this.redirectURL)) {
                throw new IllegalArgumentException("redirect back to a previously visited URL: " + this.redirectURL);
            }
            if (visitedURLs.size() > 6) {
                throw new IllegalArgumentException("redirect exceeded hard-coded limit (6): " + this.redirectURL);
            }
            visitedURLs.add(currentURL);
            currentURL = this.redirectURL;
            this.redirectURL = null;
            done = false;
        }
    }

    private void doGet(URL url) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        super.setRequestOptions(conn);
        log.debug((Object)("HttpURLConnection type: " + conn.getClass().getName() + " for GET " + url));
        if (this.headOnly) {
            conn.setRequestMethod("HEAD");
        } else {
            conn.setRequestMethod("GET");
        }
        this.setRequestAuthHeaders(conn);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            this.initHTTPS(sslConn);
        }
        conn.setInstanceFollowRedirects(this.followRedirects);
        conn.setRequestProperty("Accept", "*/*");
        this.setRequestHeaders(conn);
        this.requestStartTime = System.currentTimeMillis();
        this.checkErrors(url, conn);
        this.checkRedirects(url, conn);
        if (this.redirectURL == null) {
            this.fireEvent(2);
            this.responseStream = conn.getInputStream();
        }
    }
}

